/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.kink_lang.kink.internal.program.itree.ContentAnalysis;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeVisitor;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LocalVarContent;
import org.kink_lang.kink.internal.program.itree.UsageDefinitionAnalysis;
import org.kink_lang.kink.internal.program.itree.UsedDefinedVars;

public class FastFunItree
implements Itree,
UsedDefinedVars {
    private final Itree body;
    private final int pos;
    private final Set<LocalVar> usedLvars;
    private final Set<LocalVar> definedLvars;
    private final Set<LocalVar> freeLvars;
    private final Map<LocalVar, LocalVarContent> lvarContentMapping;

    public FastFunItree(Itree body, int pos) {
        this.body = body;
        this.pos = pos;
        UsageDefinitionAnalysis analysis = UsageDefinitionAnalysis.analyzeUseDefine(this.body);
        this.usedLvars = analysis.usedLvars();
        this.definedLvars = analysis.definedLvars();
        this.freeLvars = analysis.freeLvars();
        this.lvarContentMapping = ContentAnalysis.analyzeContent(this.body);
    }

    public Itree body() {
        return this.body;
    }

    @Override
    public int pos() {
        return this.pos;
    }

    @Override
    public Set<LocalVar> usedLvars() {
        return this.usedLvars;
    }

    @Override
    public Set<LocalVar> definedLvars() {
        return this.definedLvars;
    }

    @Override
    public Set<LocalVar> freeLvars() {
        return this.freeLvars;
    }

    public Map<LocalVar, LocalVarContent> lvarContentMapping() {
        return this.lvarContentMapping;
    }

    @Override
    public LocalVarContent getContent(LocalVar lvar) {
        return this.lvarContentMapping().getOrDefault(lvar, new LocalVarContent.Unknown());
    }

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return String.format(Locale.ROOT, "FastFunItree(%s %d)", this.body, this.pos);
    }

    private List<Object> getProperties() {
        return List.of(this.body, Integer.valueOf(this.pos));
    }

    public int hashCode() {
        return this.getProperties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof FastFunItree)) return false;
        FastFunItree fun = (FastFunItree)arg;
        if (!this.getProperties().equals(fun.getProperties())) return false;
        return true;
    }
}

