/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.CondThenPair;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RecvArgsSearcher;

public class BranchWithElseInliner
extends BaseOptimizer {
    @Override
    public Itree visit(SymcallItree org) {
        FastFunItree elseBody;
        LderefItree lastCondLderef;
        if (!org.isLocalCallOf("branch")) {
            return org;
        }
        List<ItreeElem> argElems = org.args();
        if (argElems.stream().anyMatch(ItreeElem::isSpread)) {
            return org;
        }
        List<Itree> args = argElems.stream().map(ItreeElem::expr).toList();
        if (args.size() < 2 || args.size() % 2 != 0) {
            return org;
        }
        List<Itree> beforeElse = args.subList(0, args.size() - 2);
        if (!beforeElse.stream().allMatch(a -> a instanceof FastFunItree)) {
            return org;
        }
        List<FastFunItree> beforeElseFuns = beforeElse.stream().map(a -> (FastFunItree)a).toList();
        ArrayList<CondThenPair> condThenPairs = new ArrayList<CondThenPair>();
        for (int i = 0; i < beforeElseFuns.size(); i += 2) {
            FastFunItree condFun = beforeElseFuns.get(i);
            FastFunItree bodyFun = beforeElseFuns.get(i + 1);
            if (RecvArgsSearcher.containsRecvOrArgs(condFun.body()) || RecvArgsSearcher.containsRecvOrArgs(bodyFun.body())) {
                return org;
            }
            condThenPairs.add(new CondThenPair(condFun, bodyFun));
        }
        Itree lastCond = args.get(args.size() - 2);
        if (!(lastCond instanceof LderefItree) || !(lastCondLderef = (LderefItree)lastCond).lvar().equals(new LocalVar.Original("true"))) {
            return org;
        }
        Itree lastBody = args.get(args.size() - 1);
        if (!(lastBody instanceof FastFunItree) || RecvArgsSearcher.containsRecvOrArgs((elseBody = (FastFunItree)lastBody).body())) {
            return org;
        }
        return new BranchWithElseItree(condThenPairs, elseBody, org.pos());
    }
}

