/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.SymValPair;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class TraitNewValOptimizer
extends BaseOptimizer {
    @Override
    public Itree visit(SymcallItree scall) {
        if (!this.isOptimizable(scall)) {
            return scall;
        }
        ItreeElem trait = scall.args().get(0);
        ArrayList<SymValPair> symValPairs = new ArrayList<SymValPair>();
        for (int i = 1; i < scall.args().size(); i += 2) {
            String sym = ((StrItree)scall.args().get(i).expr()).str();
            Itree val = scall.args().get(i + 1).expr();
            symValPairs.add(new SymValPair(sym, val));
        }
        return new TraitNewValItree(trait.expr(), trait.pos(), symValPairs, scall.pos());
    }

    private boolean isOptimizable(SymcallItree scall) {
        return scall.isLocalCallOf("new_val") && this.isOddNumOfArgs(scall.args()) && this.isSpreadOnFirst(scall.args()) && this.isSingleOnTail(scall.args()) && this.hasSyms(scall.args());
    }

    private boolean isOddNumOfArgs(List<ItreeElem> args) {
        return args.size() % 2 == 1;
    }

    private boolean isSpreadOnFirst(List<ItreeElem> args) {
        return args.get(0).isSpread();
    }

    private boolean isSingleOnTail(List<ItreeElem> args) {
        return args.stream().skip(1L).allMatch(ItreeElem::isSingle);
    }

    private boolean hasSyms(List<ItreeElem> args) {
        for (int i = 1; i < args.size(); i += 2) {
            if (args.get(i).expr() instanceof StrItree) continue;
            return false;
        }
        return true;
    }
}

