/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.vec;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.vec.MaybeTrait;
import org.kink_lang.kink.internal.vec.MutableVecInternal;
import org.kink_lang.kink.internal.vec.VecInternalList;

public abstract class VecInternal {
    final Vm vm;
    final Val[] vals;
    static final VarHandle VALS_VH = MethodHandles.arrayElementVarHandle(Val[].class);
    int size;

    VecInternal(Vm vm, Val[] vals, int size) {
        this.vm = vm;
        this.vals = vals;
        this.size = size;
    }

    public static VecInternal of(Vm vm, List<? extends Val> list) {
        Val[] vals = new Val[list.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = list.get(i);
        }
        return new MutableVecInternal(vm, vals, vals.length);
    }

    public static VecInternal of(Vm vm, Val[] array, int from, int to) {
        Preconds.checkRange(from, to, array.length);
        Val[] vals = new Val[to - from];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = array[from + i];
        }
        return new MutableVecInternal(vm, vals, vals.length);
    }

    public static VecInternal of(Vm vm, Val e0) {
        return new MutableVecInternal(vm, new Val[]{e0}, 1);
    }

    public static VecInternal of(Vm vm, Val e0, Val e1) {
        return new MutableVecInternal(vm, new Val[]{e0, e1}, 2);
    }

    public static VecInternal of(Vm vm, Val e0, Val e1, Val e2) {
        return new MutableVecInternal(vm, new Val[]{e0, e1, e2}, 3);
    }

    public static VecInternal of(Vm vm, Val e0, Val e1, Val e2, Val e3) {
        return new MutableVecInternal(vm, new Val[]{e0, e1, e2, e3}, 4);
    }

    public static VecInternal ofCapa(Vm vm, int capa) {
        Object[] array = new Val[capa];
        Arrays.fill(array, 0, capa, vm.nada);
        return new MutableVecInternal(vm, (Val[])array, 0);
    }

    void copyOut(int from, int len, Val[] dest, int destInd) {
        for (int i = 0; i < len; ++i) {
            Val v;
            dest[destInd + i] = v = VALS_VH.getAcquire(this.vals, from + i);
        }
    }

    void copyOutRelease(int from, int len, Val[] dest, int destInd) {
        for (int i = 0; i < len; ++i) {
            Val v = VALS_VH.getAcquire(this.vals, from + i);
            VALS_VH.setRelease(dest, destInd + i, v);
        }
    }

    public int size() {
        return this.size;
    }

    public Val get(int index) {
        Preconds.checkElemIndex(index, this.capa());
        return VALS_VH.getAcquire(this.vals, index);
    }

    @Nullable
    public abstract MaybeTrait getTrait();

    @CheckReturnValue
    public VecInternal append(Val val) {
        return this.insert(this.size, val);
    }

    @CheckReturnValue
    public abstract VecInternal set(int var1, Val var2);

    @CheckReturnValue
    public abstract VecInternal remove(int var1);

    @CheckReturnValue
    public abstract VecInternal removeRange(int var1, int var2);

    @CheckReturnValue
    public abstract VecInternal insert(int var1, Val var2);

    @CheckReturnValue
    public abstract VecInternal insertAll(int var1, VecInternal var2);

    @CheckReturnValue
    public abstract VecInternal insertRange(int var1, Val[] var2, int var3, int var4);

    public VecInternal copyRangeWithCapa(int from, int to, int newCapa) {
        Preconds.checkRange(from, to, this.capa());
        Preconds.checkArg(to - from <= newCapa, "too small capa");
        Object[] newVals = new Val[newCapa];
        int newSize = to - from;
        this.copyOut(from, newSize, (Val[])newVals, 0);
        Arrays.fill(newVals, newSize, newCapa, this.vm.nada);
        return new MutableVecInternal(this.vm, (Val[])newVals, newSize);
    }

    public VecInternal copyRange(int from, int to) {
        return this.copyRangeWithCapa(from, to, to - from);
    }

    public VecInternal copy() {
        return this.copyRange(0, this.size);
    }

    public void copyTo(Val[] dest, int destIndex, int size) {
        this.copyOut(0, size, dest, destIndex);
    }

    public int capa() {
        return this.vals.length;
    }

    public List<Val> asList() {
        return new VecInternalList(this);
    }
}

