/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.kink_lang.kink.Vm;

public class ComponentRegistry {
    private final Vm vm;
    private final AtomicReference<Map<Class<?>, Object>> mappingRef = new AtomicReference(Map.of());

    ComponentRegistry(Vm vm) {
        this.vm = vm;
    }

    public <T> T get(Class<T> klass) {
        Map<Class<?>, Object> mapping = this.mappingRef.get();
        Object result = mapping.get(klass);
        if (result == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "component for class %s is not registered", klass.getName()));
        }
        return (T)result;
    }

    public <T> void register(Class<T> klass, T component) {
        Map<Class<?>, Object> mapping;
        while (!(mapping = this.mappingRef.get()).containsKey(klass)) {
            HashMap newMapping = new HashMap(mapping);
            newMapping.put(klass, component);
            this.mappingRef.compareAndSet(mapping, newMapping);
        }
        return;
    }

    public <T> T getOrRegister(Class<T> klass, Function<Vm, T> makeComponent) {
        Object component = this.mappingRef.get().get(klass);
        if (component != null) {
            return (T)component;
        }
        this.register(klass, makeComponent.apply(this.vm));
        return (T)this.mappingRef.get().get(klass);
    }
}

