/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalInt;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.HostFunVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostFunAction;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.internal.contract.Preconds;

class HostFunBuilderImpl
implements HostFunBuilder {
    private final Vm vm;
    private final String desc;
    private final int argsMin;
    private final OptionalInt argsMax;

    HostFunBuilderImpl(Vm vm, String desc, int argsMin, OptionalInt argsMax) {
        this.vm = vm;
        this.desc = desc;
        this.argsMin = argsMin;
        this.argsMax = argsMax;
    }

    @Override
    public HostFunBuilder desc(String desc) {
        Objects.requireNonNull(desc);
        return new HostFunBuilderImpl(this.vm, desc, this.argsMin, this.argsMax);
    }

    @Override
    public HostFunBuilder take(int numArgs) {
        Preconds.checkArg(numArgs >= 0, "numArgs must be nonnegative");
        return new HostFunBuilderImpl(this.vm, this.desc, numArgs, OptionalInt.of(numArgs));
    }

    @Override
    public HostFunBuilder takeMin(int argsMin) {
        Preconds.checkArg(argsMin >= 0, "argsMin must be nonnegative");
        return new HostFunBuilderImpl(this.vm, this.desc, argsMin, OptionalInt.empty());
    }

    @Override
    public HostFunBuilder takeMinMax(int argsMin, int argsMax) {
        Preconds.checkArg(argsMin >= 0, "argsMin must be nonnegative");
        Preconds.checkArg(argsMin <= argsMax, "argsMin must be less than or equal to argsMax");
        return new HostFunBuilderImpl(this.vm, this.desc, argsMin, OptionalInt.of(argsMax));
    }

    @Override
    public FunVal action(HostFunAction action) {
        HostFunAction wrappedAction = this.argsMax.equals(OptionalInt.of(this.argsMin)) ? HostFunBuilderImpl.actionExact(this.desc, this.argsMin, action) : (this.argsMax.isPresent() ? HostFunBuilderImpl.actionMinMax(this.desc, this.argsMin, this.argsMax.getAsInt(), action) : (this.argsMin >= 1 ? HostFunBuilderImpl.actionMin(this.desc, this.argsMin, action) : action));
        return new HostFunVal(this.vm, this.desc, wrappedAction);
    }

    private static HostFunAction actionExact(String desc, int argsExact, HostFunAction rawAction) {
        return c -> {
            int args = c.argCount();
            if (args != argsExact) {
                return c.raise(String.format(Locale.ROOT, "%s: required %d arg(s), but got %d arg(s)", desc, argsExact, args));
            }
            return rawAction.action(c);
        };
    }

    private static HostFunAction actionMinMax(String desc, int argsMin, int argsMax, HostFunAction rawAction) {
        return c -> {
            int args = c.argCount();
            if (args < argsMin || argsMax < args) {
                return c.raise(String.format(Locale.ROOT, "%s: required %d to %d arg(s), but got %d arg(s)", desc, argsMin, argsMax, args));
            }
            return rawAction.action(c);
        };
    }

    private static HostFunAction actionMin(String desc, int argsMin, HostFunAction rawAction) {
        return c -> {
            int args = c.argCount();
            if (args < argsMin) {
                return c.raise(String.format(Locale.ROOT, "%s: required at least %d arg(s), but got %d arg(s)", desc, argsMin, args));
            }
            return rawAction.action(c);
        };
    }

    String getDesc() {
        return this.desc;
    }

    int getArgsMin() {
        return this.argsMin;
    }

    OptionalInt getArgsMax() {
        return this.argsMax;
    }

    public String toString() {
        return String.format(Locale.ROOT, "HostFunBuilderImpl(desc=%s argsMin=%s argsMax=%s)", this.desc, this.argsMin, this.argsMax);
    }

    private List<Object> getProperties() {
        return List.of(this.vm, this.desc, Integer.valueOf(this.argsMin), this.argsMax);
    }

    public int hashCode() {
        return this.getProperties().hashCode();
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof HostFunBuilderImpl && this.getProperties().equals(((HostFunBuilderImpl)arg).getProperties());
    }
}

