/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.LocationVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

public class TraceVal
extends Val {
    private final String sym;
    private final LocationVal location;
    private final boolean isTail;

    TraceVal(Vm vm, String sym, LocationVal location, boolean isTail) {
        super(vm, null);
        this.sym = sym;
        this.location = location;
        this.isTail = isTail;
    }

    public TraceVal onTail() {
        return new TraceVal(this.vm, this.sym, this.location, true);
    }

    public String sym() {
        return this.sym;
    }

    boolean emptySym() {
        return this.sym().isEmpty();
    }

    public LocationVal location() {
        return this.location;
    }

    boolean emptyLoc() {
        return this.location().equals(this.vm.location.of("", "", 0));
    }

    public boolean isTail() {
        return this.isTail;
    }

    public boolean isSnip() {
        return this.emptySym() && this.emptyLoc() && this.isTail;
    }

    public StackTraceElement toStackTraceElement() {
        if (this.isSnip()) {
            return new StackTraceElement("(kink)", "(snip)", null, -1);
        }
        String methodName = this.emptySym() ? "(direct-call)" : this.sym();
        String fileName = this.emptyLoc() ? null : this.location().programName();
        int lineNumber = this.emptyLoc() ? -1 : this.location().lineNum();
        return new StackTraceElement("(kink)", methodName, fileName, lineNumber);
    }

    public String toString() {
        String symRepr = this.emptySym() ? "null" : String.format(Locale.ROOT, "\u00ab%s\u00bb", this.sym());
        String locRepr = this.emptyLoc() ? "null" : String.format(Locale.ROOT, "\u00ab%s\u00bb", this.location());
        return String.format(Locale.ROOT, "TraceVal(%s %s %s)", symRepr, locRepr, this.isTail());
    }

    public String desc() {
        String close;
        if (this.emptyLoc() && this.emptySym()) {
            return this.isTail ? "{..snip..}" : "[..empty..]";
        }
        String open = this.isTail ? "{" : "[";
        String string = close = this.isTail ? "}" : "]";
        if (this.emptyLoc()) {
            return String.format(Locale.ROOT, "%s%s%s", open, this.sym(), close);
        }
        if (this.emptySym()) {
            return String.format(Locale.ROOT, "%s%s%s %s", open, this.location().desc(), close, this.location().indicator());
        }
        return String.format(Locale.ROOT, "%s%s %s%s %s", open, this.location().desc(), this.sym(), close, this.location().indicator());
    }

    private List<Object> properties() {
        return List.of(this.vm, this.sym(), this.location(), Boolean.valueOf(this.isTail()));
    }

    public int hashCode() {
        return this.properties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof TraceVal)) return false;
        TraceVal argTrace = (TraceVal)arg;
        if (!this.properties().equals(argTrace.properties())) return false;
        return true;
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.trace.sharedVars;
    }
}

