/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.callstack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kink_lang.kink.internal.callstack.CallStackSlice;
import org.kink_lang.kink.internal.callstack.Cse;
import org.kink_lang.kink.internal.callstack.FakeCallTraceCse;
import org.kink_lang.kink.internal.callstack.KontTagCse;
import org.kink_lang.kink.internal.callstack.Lnums;
import org.kink_lang.kink.internal.callstack.ResumeCse;
import org.kink_lang.kink.internal.callstack.TailTraceRingBuffer;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.contract.Preconds;

public class CallStack {
    private int sp = 0;
    private Cse[] elems;
    private TailTraceRingBuffer[] trbs;
    private long[] lnums;
    private final int maxModerateSize;
    private final int trbSize;

    public CallStack(int initCapa, int maxModerateSize, int trbSize) {
        this.elems = new Cse[initCapa];
        this.maxModerateSize = maxModerateSize;
        this.trbSize = trbSize;
        this.trbs = this.makeTrbs(initCapa);
        this.lnums = new long[initCapa];
    }

    private TailTraceRingBuffer[] makeTrbs(int initCapa) {
        TailTraceRingBuffer[] trbs = new TailTraceRingBuffer[initCapa];
        for (int i = 0; i < initCapa; ++i) {
            trbs[i] = this.makeTrb();
        }
        return trbs;
    }

    private TailTraceRingBuffer makeTrb() {
        return TailTraceRingBuffer.withSize(this.trbSize);
    }

    public boolean isModerateSize() {
        return this.sp < this.maxModerateSize;
    }

    public void pushCse(Cse elem, int programCounter, int argCount, int dataStackUsage) {
        Preconds.checkState(this.isModerateSize(), "stack overflow; you must check it by calling isModerateSize beforehand");
        this.ensureCapa(this.sp + 1);
        this.elems[this.sp] = elem;
        this.trbs[this.sp].reset();
        this.lnums[this.sp] = Lnums.makeLnum(programCounter, argCount, dataStackUsage);
        ++this.sp;
    }

    public long poppedLnum() {
        return this.lnums[this.sp];
    }

    public void pushTailTrace(Trace trace) {
        this.trbs[this.sp - 1].push(trace);
    }

    private void ensureCapa(int capa) {
        if (capa <= this.elems.length) {
            return;
        }
        int newSize = capa + 100;
        Cse[] newFrames = new Cse[newSize];
        System.arraycopy(this.elems, 0, newFrames, 0, this.elems.length);
        this.elems = newFrames;
        TailTraceRingBuffer[] newTrbs = new TailTraceRingBuffer[newSize];
        System.arraycopy(this.trbs, 0, newTrbs, 0, this.trbs.length);
        for (int i = this.trbs.length; i < newSize; ++i) {
            newTrbs[i] = this.makeTrb();
        }
        this.trbs = newTrbs;
        long[] newLnums = new long[newSize];
        System.arraycopy(this.lnums, 0, newLnums, 0, this.lnums.length);
        this.lnums = newLnums;
    }

    public ResumeCse popResumer() {
        while (this.sp >= 1) {
            Cse elem = this.removeTop();
            if (!(elem instanceof ResumeCse)) continue;
            return (ResumeCse)elem;
        }
        throw new IllegalStateException("no ResumeCse");
    }

    public void popFakeCallTrace() {
        Cse top = this.removeTop();
        Preconds.checkState(top instanceof FakeCallTraceCse, "top must be fake call trace");
    }

    private Cse removeTop() {
        Cse top = this.top();
        this.elems[this.sp - 1] = null;
        --this.sp;
        return top;
    }

    private Cse top() {
        return this.elems[this.sp - 1];
    }

    private int findDelimiterIndex(KontTagCse target) {
        for (int i = this.sp - 1; i >= 0; --i) {
            Cse elem = this.elems[i];
            if (!elem.equals(target)) continue;
            return i;
        }
        return -1;
    }

    public boolean canAbort(KontTagCse kontTag) {
        int index = this.findDelimiterIndex(kontTag);
        return index >= 0;
    }

    public CallStackSlice abort(KontTagCse kontTag) {
        int delimInd = this.findDelimiterIndex(kontTag);
        Preconds.checkArg(delimInd >= 0, "kontTag must exist on the call stack");
        int contEnd = this.sp;
        int contSize = contEnd - delimInd;
        Cse[] contCses = this.extractContCses(delimInd, contSize);
        Arrays.fill(this.elems, delimInd + 1, this.sp, null);
        TailTraceRingBuffer[] contTrbs = this.extractContTrbs(delimInd, contSize);
        this.trbs[delimInd].reset();
        long[] contLnums = this.extractContLnums(delimInd, contSize);
        this.sp = delimInd + 1;
        return new CallStackSlice(contCses, contTrbs, contLnums);
    }

    private Cse[] extractContCses(int delimInd, int contSize) {
        Cse[] slice = new Cse[contSize];
        System.arraycopy(this.elems, delimInd, slice, 0, contSize);
        return slice;
    }

    private TailTraceRingBuffer[] extractContTrbs(int delimInd, int contSize) {
        TailTraceRingBuffer[] slice = new TailTraceRingBuffer[contSize];
        for (int i = 0; i < contSize; ++i) {
            slice[i] = this.trbs[delimInd + i].makeCopy();
        }
        return slice;
    }

    private long[] extractContLnums(int delimInd, int contSize) {
        long[] contLnums = new long[contSize];
        System.arraycopy(this.lnums, delimInd, contLnums, 0, contSize);
        return contLnums;
    }

    public boolean canReplay(CallStackSlice callSlice) {
        return this.sp + callSlice.size() <= this.maxModerateSize;
    }

    public void replay(CallStackSlice slice) {
        Preconds.checkState(this.canReplay(slice), "stack overflow; must check by canReplay beforehand");
        this.ensureCapa(this.sp + slice.size());
        System.arraycopy(slice.callStackElements(), 0, this.elems, this.sp, slice.size());
        for (int i = 0; i < slice.size(); ++i) {
            TailTraceRingBuffer trb = this.trbs[this.sp + i];
            trb.copyFrom(slice.tailTraceRingBuffers()[i]);
        }
        System.arraycopy(slice.lnums(), 0, this.lnums, this.sp, slice.size());
        this.sp += slice.size();
    }

    List<Cse> elems() {
        return List.copyOf(Arrays.asList(this.elems).subList(0, this.sp));
    }

    public List<Trace> traces() {
        ArrayList<Trace> traces = new ArrayList<Trace>();
        for (int i = 0; i < this.sp; ++i) {
            int programCounter = Lnums.getProgramCounter(this.lnums[i]);
            Cse cse = this.elems[i];
            traces.add(cse.trace(programCounter));
            traces.addAll(this.trbs[i].traces());
        }
        return Collections.unmodifiableList(traces);
    }

    long[] lnums() {
        return Arrays.copyOf(this.lnums, this.sp);
    }
}

