/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.callstack;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.kink_lang.kink.LocationVal;
import org.kink_lang.kink.TraceVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.contract.Preconds;

public record Trace(int symHandle, Location location, boolean isTail) {
    public static final Trace SNIP = new Trace(0, Location.EMPTY, true);
    private static final AtomicReference<Trace[]> NON_TAIL_SYM_ONLY_TRACE_CACHE = new AtomicReference<Trace[]>(new Trace[]{null});
    private static final AtomicReference<Trace[]> TAIL_SYM_ONLY_TRACE_CACHE = new AtomicReference<Trace[]>(new Trace[]{null});

    public Trace {
        Preconds.checkArg(symHandle >= 0, "symHandle must be non-negative");
        Objects.requireNonNull(location, "location must not be null");
    }

    public static Trace of(int symHandle) {
        return Trace.produceSymOnly(symHandle, false, NON_TAIL_SYM_ONLY_TRACE_CACHE);
    }

    public static Trace ofTail(int symHandle) {
        return Trace.produceSymOnly(symHandle, true, TAIL_SYM_ONLY_TRACE_CACHE);
    }

    private static Trace produceSymOnly(int symHandle, boolean isTail, AtomicReference<Trace[]> cacheRef) {
        Trace newInstance;
        Trace cached;
        Preconds.checkArg(symHandle >= 1, "symHandle must be positive");
        Trace[] cache = cacheRef.get();
        if (symHandle >= cache.length) {
            Trace[] newCache = new Trace[symHandle + 1];
            System.arraycopy(cache, 0, newCache, 0, cache.length);
            cache = newCache;
            cacheRef.set(cache);
        }
        if ((cached = cache[symHandle]) != null) {
            return cached;
        }
        cache[symHandle] = newInstance = new Trace(symHandle, Location.EMPTY, isTail);
        return newInstance;
    }

    public static Trace of(Location location) {
        return new Trace(0, location, false);
    }

    public static Trace of(int symHandle, Location location) {
        return new Trace(symHandle, location, false);
    }

    public Trace onTail() {
        return new Trace(this.symHandle, this.location, true);
    }

    public TraceVal toTraceVal(Vm vm) {
        if (this.equals(SNIP)) {
            return vm.trace.snip();
        }
        TraceVal val = vm.trace.of(vm.sym.symFor(this.symHandle), this.produceLocVal(vm));
        return this.isTail() ? val.onTail() : val;
    }

    private LocationVal produceLocVal(Vm vm) {
        String programName = this.location.programName();
        String programText = this.location.programText();
        int pos = this.location.pos();
        return vm.location.of(programName, programText, pos);
    }
}

