/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.kink_lang.kink.BindingVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.classgen.ClassGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.TopLevelCompiler;
import org.kink_lang.kink.internal.control.Control;
import org.kink_lang.kink.internal.program.itree.Itree;

public class ItreeCompiler {
    private final Vm vm;
    private final MethodHandles.Lookup packageLookup;
    private final String programName;
    private final String programText;
    private final BindingVal binding;

    public ItreeCompiler(Vm vm, MethodHandles.Lookup packageLookup, String programName, String programText, BindingVal binding) {
        this.vm = vm;
        this.packageLookup = packageLookup;
        this.programName = programName;
        this.programText = programText;
        this.binding = binding;
    }

    public FunVal compile(Itree topLevel) {
        TopLevelCompiler topLevelCompiler = new TopLevelCompiler(this.vm, this.programName, this.programText);
        JavaClassIr jcir = topLevelCompiler.compile(topLevel);
        return Control.runWrappingThrowable(() -> {
            ClassGenerator classGen = new ClassGenerator(this.vm, this.packageLookup);
            MethodHandles.Lookup generated = classGen.generate(jcir);
            MethodHandle mh = generated.findConstructor(generated.lookupClass(), MethodType.methodType(Void.TYPE, Vm.class, Val.class));
            return mh.invoke(this.vm, this.binding);
        });
    }
}

