/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.intrinsicsupport;

import java.util.Locale;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.graph.GraphNode;

public class BranchSupport {
    private static final String DESC = "branch(...[$cond1 $then1 $cond2 $then2 ,,,])";

    private BranchSupport() {
    }

    public static FunVal condNotBool(Vm vm, int index, Val actual) {
        String param = "$cond" + (index / 2 + 1);
        String template = String.format(Locale.ROOT, "%s: result of %s must be bool, but got {}", DESC, param);
        GraphNode raise = vm.graph.raiseFormat(template, vm.graph.repr(actual));
        return vm.fun.make().action(c -> c.call(raise));
    }

    public static FunVal noMatchingCond(Vm vm) {
        String message = String.format(Locale.ROOT, "%s: no matching cond", DESC);
        return vm.fun.make().action(c -> c.raise(message));
    }
}

