/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.java;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;

public class JavaMod {
    private final Vm vm;
    public static final String MOD_NAME = "kink/javahost/JAVA";

    private JavaMod(Vm vm) {
        this.vm = vm;
    }

    public static Val makeMod(Vm vm) {
        return new JavaMod(vm).makeMod();
    }

    private Val makeMod() {
        Val javaMod = this.vm.newVal();
        javaMod.setVar(this.vm.sym.handleFor("is?"), this.vm.fun.make("JAVA.is?(Val)").take(1).action(c -> this.vm.bool.of(c.arg(0) instanceof JavaVal)));
        javaMod.setVar(this.vm.sym.handleFor("string"), this.vm.fun.make("JAVA.string(Str)").take(1).action(this::stringFun));
        javaMod.setVar(this.vm.sym.handleFor("bytes"), this.vm.fun.make("JAVA.bytes(Bin)").take(1).action(this::bytesFun));
        javaMod.setVar(this.vm.sym.handleFor("boolean"), this.vm.fun.make("JAVA.boolean(Bool)").take(1).action(this::booleanFun));
        javaMod.setVar(this.vm.sym.handleFor("char"), this.vm.fun.make("JAVA.char(Num)").take(1).action(this::charFun));
        javaMod.setVar(this.vm.sym.handleFor("byte"), this.vm.fun.make("JAVA.byte(Num)").take(1).action(this::byteFun));
        javaMod.setVar(this.vm.sym.handleFor("short"), this.vm.fun.make("JAVA.short(Num)").take(1).action(this::shortFun));
        javaMod.setVar(this.vm.sym.handleFor("int"), this.vm.fun.make("JAVA.int(Num)").take(1).action(this::intFun));
        javaMod.setVar(this.vm.sym.handleFor("long"), this.vm.fun.make("JAVA.long(Num)").take(1).action(this::longFun));
        javaMod.setVar(this.vm.sym.handleFor("float"), this.vm.fun.make("JAVA.float(Num)").take(1).action(this::floatFun));
        javaMod.setVar(this.vm.sym.handleFor("double"), this.vm.fun.make("JAVA.double(Num)").take(1).action(this::doubleFun));
        javaMod.setVar(this.vm.sym.handleFor("big_integer"), this.vm.fun.make("JAVA.big_integer(Num)").take(1).action(this::bigIntegerFun));
        javaMod.setVar(this.vm.sym.handleFor("big_decimal"), this.vm.fun.make("JAVA.big_decimal(Num)").take(1).action(this::bigDecimalFun));
        javaMod.setVar(this.vm.sym.handleFor("wrap"), this.vm.fun.make("JAVA.wrap").take(1).action(this::wrapFun));
        javaMod.setVar(this.vm.sym.handleFor("boolean_class"), this.vm.fun.constant(this.vm.java.of(Boolean.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("char_class"), this.vm.fun.constant(this.vm.java.of(Character.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("byte_class"), this.vm.fun.constant(this.vm.java.of(Byte.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("short_class"), this.vm.fun.constant(this.vm.java.of(Short.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("int_class"), this.vm.fun.constant(this.vm.java.of(Integer.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("long_class"), this.vm.fun.constant(this.vm.java.of(Long.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("float_class"), this.vm.fun.constant(this.vm.java.of(Float.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("double_class"), this.vm.fun.constant(this.vm.java.of(Double.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("void_class"), this.vm.fun.constant(this.vm.java.of(Void.TYPE, Class.class)));
        javaMod.setVar(this.vm.sym.handleFor("null"), this.vm.fun.constant(this.vm.java.of(null, Object.class)));
        javaMod.setVar(this.vm.sym.handleFor("true"), this.vm.fun.constant(this.vm.java.of(true, Boolean.TYPE)));
        javaMod.setVar(this.vm.sym.handleFor("false"), this.vm.fun.constant(this.vm.java.of(false, Boolean.TYPE)));
        javaMod.setVar(this.vm.sym.handleFor("class"), this.vm.fun.make("JAVA.class(Class_name)").take(1).action(this::classFun));
        return javaMod;
    }

    private HostResult stringFun(CallContext c) {
        Val strVal = c.arg(0);
        if (!(strVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.string(Str): Str must be a str, but got {}", this.vm.graph.repr(strVal)));
        }
        return this.vm.java.of(((StrVal)strVal).string(), String.class);
    }

    private HostResult bytesFun(CallContext c) {
        Val binVal = c.arg(0);
        if (!(binVal instanceof BinVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.bytes(Bin): Bin must be a bin, but got {}", this.vm.graph.repr(binVal)));
        }
        return this.vm.java.of(((BinVal)binVal).bytes(), byte[].class);
    }

    private HostResult booleanFun(CallContext c) {
        Val boolVal = c.arg(0);
        if (boolVal == this.vm.bool.trueVal) {
            return this.vm.java.of(true, Boolean.TYPE);
        }
        if (boolVal == this.vm.bool.falseVal) {
            return this.vm.java.of(false, Boolean.TYPE);
        }
        return c.call(this.vm.graph.raiseFormat("JAVA.boolean(Bool): Bool must be a bool, but got {}", this.vm.graph.repr(boolVal)));
    }

    private HostResult charFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.char(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        int num = ((NumVal)numVal).bigDecimal().intValue();
        return this.vm.java.of(Character.valueOf((char)num), Character.TYPE);
    }

    private HostResult byteFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.byte(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().byteValue(), Byte.TYPE);
    }

    private HostResult shortFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.short(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().shortValue(), Short.TYPE);
    }

    private HostResult intFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.int(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().intValue(), Integer.TYPE);
    }

    private HostResult longFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.long(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().longValue(), Long.TYPE);
    }

    private HostResult floatFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.float(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(Float.valueOf(((NumVal)numVal).bigDecimal().floatValue()), Float.TYPE);
    }

    private HostResult doubleFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.double(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().doubleValue(), Double.TYPE);
    }

    private HostResult bigIntegerFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.big_integer(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal().toBigInteger(), BigInteger.class);
    }

    private HostResult bigDecimalFun(CallContext c) {
        Val numVal = c.arg(0);
        if (!(numVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.big_decimal(Num): Num must be a num, but got {}", this.vm.graph.repr(numVal)));
        }
        return this.vm.java.of(((NumVal)numVal).bigDecimal(), BigDecimal.class);
    }

    private HostResult wrapFun(CallContext c) {
        return this.vm.java.of(c.arg(0), Val.class);
    }

    private HostResult classFun(CallContext c) {
        Val nameVal = c.arg(0);
        if (!(nameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("JAVA.class(Class_name): Class_name must be a str, but got {}", this.vm.graph.repr(nameVal)));
        }
        StrVal nameStr = (StrVal)nameVal;
        String name = nameStr.string();
        MethodHandles.Lookup lookup = MethodHandles.lookup().dropLookupMode(16);
        try {
            Class<?> klass = lookup.findClass(name);
            return this.vm.java.of(klass, Class.class);
        }
        catch (IllegalAccessException iae) {
            return c.raise(String.format(Locale.ROOT, "JAVA.class(Class_name): no access privilege to %s", name));
        }
        catch (ClassNotFoundException cnfe) {
            return c.raise(String.format(Locale.ROOT, "JAVA.class(Class_name): class not found %s", name));
        }
    }
}

