/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itree;

import java.util.HashSet;
import java.util.Set;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.DeepTransformer;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;

class UsageDefinitionAnalysis
implements DeepTransformer.Callback {
    private final Set<LocalVar> used = new HashSet<LocalVar>();
    private final Set<LocalVar> defined = new HashSet<LocalVar>();

    UsageDefinitionAnalysis() {
    }

    Set<LocalVar> usedLvars() {
        return Set.copyOf(this.used);
    }

    Set<LocalVar> definedLvars() {
        return Set.copyOf(this.defined);
    }

    Set<LocalVar> freeLvars() {
        HashSet<LocalVar> set = new HashSet<LocalVar>(this.used);
        set.removeAll(this.defined);
        return Set.copyOf(set);
    }

    static UsageDefinitionAnalysis analyzeUseDefine(Itree body) {
        UsageDefinitionAnalysis analysis = new UsageDefinitionAnalysis();
        DeepTransformer.deepTransform(body, analysis);
        return analysis;
    }

    @Override
    public LocalVar storeLvar(LocalVar lvar) {
        this.defined.add(lvar);
        return lvar;
    }

    @Override
    public LocalVar derefLvar(LocalVar lvar) {
        this.used.add(lvar);
        return lvar;
    }

    @Override
    public Itree itree(Itree itree) {
        itree.accept(new Visitor());
        return itree;
    }

    private class Visitor
    extends SkeltonItreeVisitor<Void> {
        private Visitor() {
            super((Itree itree) -> null);
        }

        @Override
        public Void visit(FastFunItree nested) {
            UsageDefinitionAnalysis.this.used.addAll(nested.freeLvars());
            return null;
        }

        @Override
        public Void visit(IfItree preloadedIf) {
            this.traverseSub(preloadedIf.trueFun().body());
            preloadedIf.falseFun().map(FastFunItree::body).ifPresent(this::traverseSub);
            return null;
        }

        @Override
        public Void visit(BranchItree branch) {
            branch.condThenPairs().stream().forEach(condThen -> {
                this.traverseSub(condThen.condFun().body());
                this.traverseSub(condThen.thenFun().body());
            });
            return null;
        }

        @Override
        public Void visit(BranchWithElseItree branch) {
            branch.condThenPairs().stream().forEach(condThen -> {
                this.traverseSub(condThen.condFun().body());
                this.traverseSub(condThen.thenFun().body());
            });
            this.traverseSub(branch.elseThenFun().body());
            return null;
        }

        private void traverseSub(Itree sub) {
            DeepTransformer.deepTransform(sub, UsageDefinitionAnalysis.this);
        }
    }
}

