/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.HashMap;
import java.util.Map;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LocalVarContent;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.OptimizerFactory;

public class ContentPropagator
extends BaseOptimizer {
    private final Map<LocalVar, LocalVarContent> lvarContentMapping;

    public ContentPropagator(Map<LocalVar, LocalVarContent> lvarContentMapping) {
        this.lvarContentMapping = lvarContentMapping;
    }

    @Override
    public Itree visit(LderefItree lderef) {
        LocalVarContent content = this.lvarContentMapping.get(lderef.lvar());
        if (content instanceof LocalVarContent.Alias) {
            LocalVarContent.Alias alias = (LocalVarContent.Alias)content;
            return new LderefItree(alias.lvar(), lderef.pos());
        }
        return lderef;
    }

    static Factory factory() {
        return new Factory(Map.of());
    }

    static class Factory
    implements OptimizerFactory {
        final Map<LocalVar, LocalVarContent> lvarContentMapping;

        Factory(Map<LocalVar, LocalVarContent> lvarContentMapping) {
            this.lvarContentMapping = lvarContentMapping;
        }

        @Override
        public Factory makeFactory(FastFunItree enclosing) {
            HashMap<LocalVar, LocalVarContent> newMapping = new HashMap<LocalVar, LocalVarContent>(this.lvarContentMapping);
            newMapping.putAll(enclosing.lvarContentMapping());
            return new Factory(newMapping);
        }

        public ContentPropagator makeOptimizer() {
            return new ContentPropagator(this.lvarContentMapping);
        }
    }
}

