/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itreeoptimize.ArgsPassingOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.AssignmentOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.BiArithmeticInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.BranchInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.BranchWithElseInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.ConstantOptimizerFactory;
import org.kink_lang.kink.internal.program.itreeoptimize.ContentPropagator;
import org.kink_lang.kink.internal.program.itreeoptimize.DeadLstoreEliminator;
import org.kink_lang.kink.internal.program.itreeoptimize.DeparenOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.EliminateUnusedOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.FastFunBodyOptimizerFactory;
import org.kink_lang.kink.internal.program.itreeoptimize.FlattenSeqOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.FunMcallToSymcallOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.IfInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.LderefOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.LetRecChainer;
import org.kink_lang.kink.internal.program.itreeoptimize.LetRecProducer;
import org.kink_lang.kink.internal.program.itreeoptimize.LetRecReducer;
import org.kink_lang.kink.internal.program.itreeoptimize.LetSymcallInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.LstoreOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.MinusConstantFolder;
import org.kink_lang.kink.internal.program.itreeoptimize.NestedArgsPassingOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.NestedVecAssignmentInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.OptRestVecAssignmentOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.OptVecAssignmentOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.OptimizerFactory;
import org.kink_lang.kink.internal.program.itreeoptimize.ParenContOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RecursiveOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RepetitiveOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.RestVecAssignmentOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.SimpleNewValInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.SlowFunBodyOptimizerFactory;
import org.kink_lang.kink.internal.program.itreeoptimize.SsafyOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.StoreOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.TraitNewValOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.UnnestArgsPassingOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.VarrefVecAssignmentInliner;
import org.kink_lang.kink.internal.program.itreeoptimize.VarrefVecAssignmentToLocalOptimizer;

public final class ItreeOptimizers {
    private static final System.Logger LOGGER = System.getLogger(ItreeOptimizers.class.getName());
    private static final List<OptimizerFactory> MAIN_FACTORIES = List.of(new ConstantOptimizerFactory(new ParenContOptimizer()), new ConstantOptimizerFactory(new FlattenSeqOptimizer()), new ConstantOptimizerFactory(new LderefOptimizer()), new ConstantOptimizerFactory(new AssignmentOptimizer()), new ConstantOptimizerFactory(new MinusConstantFolder()), new ConstantOptimizerFactory(new StoreOptimizer()), new ConstantOptimizerFactory(new LstoreOptimizer()), new ConstantOptimizerFactory(new NestedVecAssignmentInliner()), new ConstantOptimizerFactory(new OptVecAssignmentOptimizer()), new ConstantOptimizerFactory(new OptRestVecAssignmentOptimizer()), new ConstantOptimizerFactory(new RestVecAssignmentOptimizer()), new ConstantOptimizerFactory(new VarrefVecAssignmentInliner()), new ConstantOptimizerFactory(new VarrefVecAssignmentToLocalOptimizer()), new ConstantOptimizerFactory(new BiArithmeticInliner()), new ConstantOptimizerFactory(new ArgsPassingOptimizer()), new ConstantOptimizerFactory(new NestedArgsPassingOptimizer()), new ConstantOptimizerFactory(new UnnestArgsPassingOptimizer()), new ConstantOptimizerFactory(new FunMcallToSymcallOptimizer()), new ConstantOptimizerFactory(new LetSymcallInliner()), new SlowFunBodyOptimizerFactory(new LetRecProducer()), new ConstantOptimizerFactory(new LetRecChainer()), new FastFunBodyOptimizerFactory(LetRecReducer::new), ContentPropagator.factory(), new FastFunBodyOptimizerFactory(DeadLstoreEliminator::new), new ConstantOptimizerFactory(new EliminateUnusedOptimizer()), new ConstantOptimizerFactory(new DeparenOptimizer()));
    private static final List<OptimizerFactory> AFTER_SSA_PHASE = List.of(new FastFunBodyOptimizerFactory(fun -> new IfInliner()), new FastFunBodyOptimizerFactory(fun -> new BranchInliner()), new FastFunBodyOptimizerFactory(fun -> new BranchWithElseInliner()), new ConstantOptimizerFactory(new TraitNewValOptimizer()), new ConstantOptimizerFactory(new SimpleNewValInliner()));
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    private static final Supplier<String> UNIQ_SUPPLIER = () -> Long.toString(COUNTER.getAndIncrement());

    ItreeOptimizers() {
        throw new UnsupportedOperationException("should not be instantiated");
    }

    private static UnaryOperator<Itree> makePhase(List<OptimizerFactory> phaseFactories) {
        ArrayList<OptimizerFactory> factories = new ArrayList<OptimizerFactory>(phaseFactories);
        factories.addAll(MAIN_FACTORIES);
        return new RepetitiveOptimizer(List.of(new RecursiveOptimizer(factories)));
    }

    private static OptimizerFactory ssafyFactory(Supplier<String> uniqSupplier) {
        return new ConstantOptimizerFactory(new SsafyOptimizer(uniqSupplier));
    }

    public static Function<Itree, Itree> getOptimizer() {
        return ItreeOptimizers.makeOptimizer(UNIQ_SUPPLIER);
    }

    static Function<Itree, Itree> makeOptimizer(Supplier<String> uniqSupplier) {
        return ItreeOptimizers.makePhase(List.of(ItreeOptimizers.ssafyFactory(uniqSupplier))).andThen(ItreeOptimizers.makePhase(AFTER_SSA_PHASE)).andThen(itree -> {
            LOGGER.log(System.Logger.Level.TRACE, "optimized to {0}", itree);
            return itree;
        });
    }
}

