/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.NestedParam;
import org.kink_lang.kink.internal.program.itree.NestedVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VecItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class NestedVecAssignmentInliner
extends BaseOptimizer {
    @Override
    public Itree visit(AssignmentItree itree) {
        return this.extractParams(itree.lhs()).map(params -> new NestedVecAssignmentItree((List<NestedParam>)params, itree.rhs(), itree.pos())).orElse(itree);
    }

    private Optional<List<NestedParam>> extractParams(Itree lhs) {
        if (!(lhs instanceof VecItree)) {
            return Optional.empty();
        }
        VecItree vec = (VecItree)lhs;
        List<ItreeElem> lhsElems = vec.elems();
        ArrayList<NestedParam> params = new ArrayList<NestedParam>();
        for (ItreeElem elem : lhsElems) {
            NestedParam param = this.extractParam(elem);
            if (param == null) {
                return Optional.empty();
            }
            params.add(param);
        }
        return Optional.of(params);
    }

    @Nullable
    private NestedParam extractParam(ItreeElem elem) {
        if (!(elem instanceof Itree)) {
            return null;
        }
        Itree lhs = (Itree)elem;
        if (lhs instanceof VarrefItree) {
            VarrefItree varref = (VarrefItree)lhs;
            if (!(varref.owner() instanceof BindingItree)) {
                return null;
            }
            return new LocalVar.Original(varref.sym());
        }
        if (lhs instanceof VecItree) {
            VecItree tuple = (VecItree)lhs;
            ArrayList<LocalVar> lvars = new ArrayList<LocalVar>();
            for (ItreeElem tupleElem : tuple.elems()) {
                if (!(tupleElem instanceof VarrefItree)) {
                    return null;
                }
                VarrefItree tupleElemVarref = (VarrefItree)tupleElem;
                if (!(tupleElemVarref.owner() instanceof BindingItree)) {
                    return null;
                }
                lvars.add(new LocalVar.Original(tupleElemVarref.sym()));
            }
            return new NestedParam.Tuple(lvars);
        }
        return null;
    }
}

