/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Supplier;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.ssafy.SsaChecker;
import org.kink_lang.kink.internal.program.itreeoptimize.ssafy.Ssafier;

public class SsafyOptimizer
extends BaseOptimizer {
    private final Supplier<String> uniqSupplier;

    public SsafyOptimizer(Supplier<String> uniqSupplier) {
        this.uniqSupplier = uniqSupplier;
    }

    @Override
    public Itree visit(SlowFunItree itree) {
        if (SsaChecker.canConvertToSsa(itree.body())) {
            Itree body = Ssafier.ssafy(itree.body(), this.uniqSupplier);
            return new FastFunItree(body, itree.pos());
        }
        return itree;
    }
}

