package org.kink_lang.kink;

/**
 * A local binding val.
 */
public class BindingVal extends Val {

    /**
     * Constructs a local binding with no own local vars.
     *
     * @param vm the vm.
     */
    BindingVal(Vm vm) {
        super(vm, null);
    }

    /**
     * Constructs a local binding copying orig.
     */
    private BindingVal(BindingVal orig) {
        super(orig);
    }

    @Override
    SharedVars sharedVars() {
        return vm.binding.sharedVars;
    }

    /**
     * Returns a duplicated binding.
     */
    BindingVal dup() {
        return new BindingVal(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
