package org.kink_lang.kink;

import java.util.Locale;

import org.kink_lang.kink.internal.callstack.CallStack;
import org.kink_lang.kink.internal.callstack.ResumeCse;

import javax.annotation.Nullable;

/**
 * FunVal compiled from a Kink fun.
 */
abstract class GeneratedFunValBase extends FunVal implements ResumeCse {

    /**
     * Constructs a fun.
     */
    GeneratedFunValBase(Vm vm) {
        super(vm);
    }

    @Override
    void run(StackMachine stackMachine) {
        resume(stackMachine, null, 0);
    }

    @Override
    String getRepr() {
        return String.format(Locale.ROOT,
                "(fun variant=%s _desc=%s val_id=%s)",
                getClass().getSimpleName(),
                desc(),
                identity());
    }

    /**
     * Returns the description of the fun.
     */
    abstract String desc();

    /**
     * Starts or resumes execution.
     */
    final void resume(StackMachine stackMachine, @Nullable Val contParam, int programCounter) {
        DataStack dataStack = stackMachine.getDataStack();
        if (! dataStack.ensureCapaSpPlus(dataStackUsageUpperBound())) {
            stackMachine.transitionToRaise("data stack overflow");
            return;
        }
        doResume(stackMachine,
                contParam,
                programCounter,
                stackMachine.getCallStack(),
                dataStack,
                stackMachine.getArgCount());
    }

    /**
     * Starts or resumes execution.
     */
    abstract void doResume(
            StackMachine stackMachine,
            @Nullable Val contParam,
            int programCounter,
            CallStack callStack,
            DataStack dataStack,
            int argCount);

    /**
     * Returns the upper bound of data stack usage excluding spreading.
     */
    abstract int dataStackUsageUpperBound();

}

// vim: et sw=4 sts=4 fdm=marker
