package org.kink_lang.kink;

import org.kink_lang.kink.internal.sym.SymRegistryImpl;

import java.util.HashMap;
import java.util.Map;

/**
 * The factory of {@linkplain SharedVars} instances.
 */
public final class SharedVarsFactory {

    /** The vm. */
    private final Vm vm;

    /** The minimal var mapping containing only the default repr. */
    final SharedVars minimal;

    /**
     * Package-local constructor.
     */
    SharedVarsFactory(Vm vm) {
        this.vm = vm;
        this.minimal = of(Map.of());
    }

    /**
     * Returns a {@link SharedVars} instance containing the entries of {@code map}.
     *
     * @param map the map of variables.
     * @return a set of shared vars.
     */
    public SharedVars of(Map<Integer, Val> map) {
        Map<Integer, Val> combinedMap = new HashMap<>();
        combinedMap.put(SymRegistryImpl.REPR, vm.defaultRepr);
        combinedMap.putAll(map);
        return SharedVars.of(combinedMap);
    }

}

// vim: et sw=4 sts=4 fdm=marker
