package org.kink_lang.kink.hostfun;

import org.kink_lang.kink.Val;

/**
 * The reaction of a host fun on the result of invocation.
 */
@FunctionalInterface
public interface HostFunReaction {

    /**
     * Performs reaction on the result of invocation.
     *
     * @param ctx the context of the host fun.
     * @param calleeResult the result of the invocation.
     * @return the result value, or the call flow.
     * @throws Throwable any exception
     */
    HostResult reaction(HostContext ctx, Val calleeResult) throws Throwable;

}

// vim: et sw=4 sts=4 fdm=marker
