package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;

import org.kink_lang.kink.Val;

/**
 * The execution graph which results a graph.
 */
class ValGraphNode implements GraphNode {

    /** The val to be the result of the execution. */
    private final Val val;

    /**
     * Constructs a val graph.
     */
    ValGraphNode(Val val) {
        this.val = val;
    }

    @Override
    public HostResult evaluateIn(HostContext c) {
        return this.val;
    }

}

// vim: et sw=4 sts=4 fdm=marker
