package org.kink_lang.kink.internal.function;

/**
 * A quaternary function.
 *
 * @param <T0> the type of the #0 argument.
 * @param <T1> the type of the #1 argument.
 * @param <T2> the type of the #2 argument.
 * @param <T3> the type of the #3 argument.
 * @param <R> the type of the result.
 */
@FunctionalInterface
public interface Function4<T0, T1, T2, T3, R> {

    /**
     * Applies the function to the given arguments.
     *
     * @param a0 the #0 argument.
     * @param a1 the #1 argument.
     * @param a2 the #2 argument.
     * @param a3 the #3 argument.
     * @return the result of the function.
     */
    R apply(T0 a0, T1 a1, T2 a2, T3 a3);

}

// vim: et sw=4 sts=4 fdm=marker
