package org.kink_lang.kink.internal.intrinsicsupport;

import java.util.Locale;

import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

/**
 * Funs for branch.
 */
public class BranchSupport {

    /**
     * Not instantiated.
     */
    private BranchSupport() {
    }

    /** The description of branch. */
    private static final String DESC = "branch(...[$cond1 $then1 $cond2 $then2 ,,,])";

    /**
     * Returns a nullary fun raising cond-result-not-bool error.
     *
     * @param vm the vm.
     * @param index the arg index of the cond fun.
     * @param actual the actual result of the cond fun.
     * @return a nullary fun raising cond-result-not-bool error.
     */
    public static FunVal condNotBool(Vm vm, int index, Val actual) {
        String param = "$cond" + (index / 2 + 1);
        String template = String.format(Locale.ROOT,
                "%s: result of %s must be bool, but got {}",
                DESC, param);
        var raise = vm.graph.raiseFormat(template, vm.graph.repr(actual));
        return vm.fun.make().action(c -> c.call(raise));
    }

    /**
     * Returns a nullary fun raising no-matching-cond error.
     *
     * @param vm the vm.
     * @return a nullary fun raising no-matching-cond error.
     */
    public static FunVal noMatchingCond(Vm vm) {
        String message = String.format(Locale.ROOT, "%s: no matching cond", DESC);
        return vm.fun.make().action(c -> c.raise(message));
    }

}

// vim: et sw=4 sts=4 fdm=marker
