package org.kink_lang.kink.internal.program.ast;

/**
 * A visitor of an expression.
 *
 * @param <T> the result type of visit methods.
 */
public interface ExprVisitor<T> {

    /**
     * Visits a seq.
     *
     * @param seq the seq.
     * @return the result.
     */
    public abstract T visitSeq(SeqExpr seq);

    /**
     * Vists a num expression.
     *
     * @param num the num expression.
     * @return the result.
     */
    public abstract T visitNum(NumExpr num);

    /**
     * Visits a str expression.
     *
     * @param str the str expression.
     * @return the result.
     */
    public abstract T visitStr(StrExpr str);

    /**
     * Visits a binding expression.
     *
     * @param binding the binding expression.
     * @return the result.
     */
    public abstract T visitBinding(BindingExpr binding);

    /**
     * Visits a deref expression.
     *
     * @param deref the deref expression.
     * @return the result.
     */
    public abstract T visitDeref(DerefExpr deref);

    /**
     * Visits a varref expression.
     *
     * @param varref the varref expression.
     * @return the result.
     */
    public abstract T visitVarref(VarrefExpr varref);

    /**
     * Visits a fun.
     *
     * @param fun the fun expression.
     * @return the result.
     */
    public abstract T visitFun(FunExpr fun);

    /**
     * Visits a vec expression.
     *
     * @param vec the vec expression.
     * @return the result
     */
    public abstract T visitVec(VecExpr vec);

    /**
     * Visits a mcall expression.
     *
     * @param mcall the mcall expression.
     * @return the result.
     */
    public abstract T visitMcall(McallExpr mcall);

    /**
     * Visits an rcall expression.
     *
     * @param rcall the rcall expression.
     * @return the result.
     */
    public abstract T visitRcall(RcallExpr rcall);

}

// vim: et sw=4 sts=4 fdm=marker
