package org.kink_lang.kink.internal.program.ast;

import java.util.List;

/**
 * An attributional call expression without an explicit recv.
 *
 * @param ownerRecv the owner-recv.
 * @param sym       the sym.
 * @param args      the actual args.
 * @param pos       the start pos of the node.
 */
public record McallExpr(Expr ownerRecv, String sym,
                        List<Elem> args, int pos) implements Expr {

    /**
     * Constructs an attributional call expression without an explicit recv.
     *
     * @param ownerRecv the owner-recv.
     * @param sym       the sym.
     * @param args      the actual args.
     * @param pos       the start pos of the node.
     */
    public McallExpr {
        args = List.copyOf(args);
    }

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitMcall(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
