package org.kink_lang.kink.internal.program.itree;

/**
 * A lderef itree.
 *
 * @param lvar the local var.
 * @param pos the pos of the itree on the program text.
 */
public record LderefItree(LocalVar lvar, int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
