package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Algebraic data type of params of NestedArgsPassingItree.
 */
public sealed interface NestedParam permits LocalVar, NestedParam.Tuple {

    /**
     * Param which is a tuple of lvars.
     *
     * @param lvars the local vars.
     */
    record Tuple(List<LocalVar> lvars) implements NestedParam {

        // CHECKSTYLE.OFF: JavadocMethod
        /**
         * Constructs a tuple.
         *
         * @param lvars the local vars.
         */
        public Tuple {
            lvars = List.copyOf(lvars);
        }
        // CHECKSTYLE.ON: JavadocMethod

        @Override
        public String lhsRepr() {
            return lvars().stream()
                .map(LocalVar::lhsRepr)
                .collect(Collectors.joining(" ", "[", "]"));
        }

        /**
         * Returns the arity of the params.
         *
         * @return the arity of the params.
         */
        public int arity() {
            return lvars().size();
        }
    }

    /**
     * Returns the string representation as an LHS.
     *
     * @return the string representation as an LHS.
     */
    String lhsRepr();

}

// vim: et sw=4 sts=4 fdm=marker
