package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Applies inlining of calls of branch in the form below.
 *
 * <pre>
 * branch(
 *   { cond1 } { body1 }
 *   { cond2 } { body2 }
 *   ,,,
 *   { condn } { bodyn }
 * )
 * </pre>
 *
 * <p>This inlining must take place under the body of IndexFunItree.</p>
 */
public class BranchInliner extends BaseOptimizer {

    @Override
    public Itree visit(SymcallItree scall) {
        if (! scall.isLocalCallOf("branch")) {
            return scall;
        }

        List<ItreeElem> argElems = scall.args();
        if (argElems.size() % 2 != 0) {
            return scall;
        }

        if (! argElems.stream().allMatch(ItreeElem::isSingle)) {
            return scall;
        }
        List<Itree> args = argElems.stream().map(ItreeElem::expr).toList();

        if (! args.stream().allMatch(arg -> arg instanceof FastFunItree)) {
            return scall;
        }
        List<FastFunItree> funs = args.stream()
            .map(itree -> (FastFunItree) itree)
            .toList();

        List<CondThenPair> condThenPairs = new ArrayList<>();
        for (int i = 0; i < funs.size(); i += 2) {
            FastFunItree condFun = funs.get(i);
            FastFunItree bodyFun = funs.get(i + 1);
            if (RecvArgsSearcher.containsRecvOrArgs(condFun.body())
                    || RecvArgsSearcher.containsRecvOrArgs(bodyFun.body())) {
                return scall;
            }
            condThenPairs.add(new CondThenPair(condFun, bodyFun));
        }

        return new BranchItree(condThenPairs, scall.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
