package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Unifies consequent letrec into a single letrec.
 */
public class LetRecChainer extends BaseOptimizer {

    @Override
    public Itree visit(SeqItree seq) {
        List<Itree> resultSteps = new ArrayList<>();
        List<LetRecItree> consequent = new ArrayList<>();
        Supplier<Void> addChainIfAny = () -> {
            if (! consequent.isEmpty()) {
                resultSteps.add(chain(consequent));
                consequent.clear();
            }
            return null;
        };
        for (Itree step : Operations.toSteps(seq)) {
            if (step instanceof LetRecItree) {
                consequent.add((LetRecItree) step);
            } else {
                addChainIfAny.get();
                resultSteps.add(step);
            }
        }
        addChainIfAny.get();
        return new SeqItree(resultSteps, seq.pos());
    }

    /**
     * Returns a unified letrec.
     */
    private LetRecItree chain(List<LetRecItree> consequent) {
        int pos = consequent.get(0).pos();
        List<LetRecItree.LvarFunPair> pairs = consequent.stream()
            .flatMap(letrec -> letrec.lvarFunPairs().stream())
            .toList();
        return new LetRecItree(pairs, pos);
    }

}

// vim: et sw=4 sts=4 fdm=marker
