package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Operations on itrees.
 */
class Operations {

    /**
     * Should not be instantiated.
     */
    Operations() {
        throw new UnsupportedOperationException("should not be instantiated");
    }

    /**
     * Extracts steps of the itree.
     */
    static List<Itree> toSteps(Itree itree) {
        return itree instanceof SeqItree
            ? ((SeqItree) itree).steps()
            : List.of(itree);
    }

}

// vim: et sw=4 sts=4 fdm=marker
