package org.kink_lang.kink.internal.vec;

import java.util.AbstractList;
import java.util.RandomAccess;

import org.kink_lang.kink.Val;

/**
 * A list which is a view of a vec internal.
 */
class VecInternalList extends AbstractList<Val> implements RandomAccess {

    /** The backing vec internal. */
    private final VecInternal vecInternal;

    /**
     * Constructs a list.
     */
    VecInternalList(VecInternal vecInternal) {
        this.vecInternal = vecInternal;
    }

    @Override
    public int size() {
        return this.vecInternal.size();
    }

    @Override
    public Val get(int index) {
        return this.vecInternal.get(index);
    }

}

// vim: et sw=4 sts=4 fdm=marker
