/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VarrefVal;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunReaction;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.intrinsicsupport.ArgsSupport;
import org.kink_lang.kink.internal.num.NumOperations;
import org.kink_lang.kink.internal.vec.VecInternal;

public class VecHelper {
    private final Vm vm;
    private VecInternal empty;
    private int storeHandle;
    private int passArgHandle;
    private int passNothingHandle;
    private int passRestHandle;
    private int opEqHandle;
    private int opLtHandle;
    private int reprVecHandle;
    private int eachHandle;
    private int sortHandle;
    private int allP;
    private int anyP;
    private int haveP;
    private int newHandle;
    private FunVal defaultPrecedesFun;
    SharedVars sharedVars;

    VecHelper(Vm vm) {
        this.vm = vm;
    }

    void init() {
        this.empty = VecInternal.of(this.vm, new Val[0], 0, 0);
        this.storeHandle = this.vm.sym.handleFor("op_store");
        this.passArgHandle = this.vm.sym.handleFor("pass_arg");
        this.passNothingHandle = this.vm.sym.handleFor("pass_nothing");
        this.passRestHandle = this.vm.sym.handleFor("pass_rest");
        this.opEqHandle = this.vm.sym.handleFor("op_eq");
        this.opLtHandle = this.vm.sym.handleFor("op_lt");
        this.reprVecHandle = this.vm.sym.handleFor("repr_vec");
        this.eachHandle = this.vm.sym.handleFor("each");
        this.sortHandle = this.vm.sym.handleFor("sort");
        this.allP = this.vm.sym.handleFor("all?");
        this.anyP = this.vm.sym.handleFor("any?");
        this.haveP = this.vm.sym.handleFor("have?");
        this.newHandle = this.vm.sym.handleFor("new");
        this.defaultPrecedesFun = this.vm.fun.make("(compare)").take(2).action(c -> c.call(c.arg(0), this.opLtHandle).args(c.arg(1)));
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod(vars, "Vec", "size", "", 0, (c, vec, desc) -> this.vm.num.of(vec.vecInternal().size()));
        this.addMethod(vars, "Vec", "empty?", "", 0, (c, vec, desc) -> this.vm.bool.of(vec.vecInternal().size() == 0));
        this.addMethod(vars, "Vec", "get", "(Ind)", 1, this::getMethod);
        this.addMethod(vars, "Vec", "front", "", 0, this::frontMethod);
        this.addMethod(vars, "Vec", "back", "", 0, this::backMethod);
        this.addMethod(vars, "Vec", "set", "(Ind Elem)", 2, this::setMethod);
        this.addMethod(vars, "Vec", "dup", "", 0, this::dupMethod);
        this.addMethod(vars, "Vec", "rev", "", 0, this::revMethod);
        this.addTakeDropMethod(vars, "take_front", 0, 0, 1, 0);
        this.addTakeDropMethod(vars, "take_back", -1, 1, 0, 1);
        this.addTakeDropMethod(vars, "drop_front", 1, 0, 0, 1);
        this.addTakeDropMethod(vars, "drop_back", 0, 0, -1, 1);
        this.addMethod(vars, "Vec", "slice", "(From_pos To_pos)", 2, this::sliceMethod);
        this.addMethod(vars, "Vec", "clear", "", 0, this::clearMethod);
        this.addMethod(vars, "Vec", "clear_slice", "(From_pos To_pos)", 2, this::clearSliceMethod);
        this.addMethod(vars, "Vec", "push_front", "(Elem)", 1, this::pushFront);
        this.addMethod(vars, "Vec", "push_back", "(Elem)", 1, this::pushBack);
        this.addMethod(vars, "Vec", "push_at", "(Ind Elem)", 2, this::pushAt);
        this.addMethod(vars, "Vec", "push_each_front", "(Eacher)", 1, this::pushEachFront);
        this.addMethod(vars, "Vec", "push_each_back", "(Eacher)", 1, this::pushEachBack);
        this.addMethod(vars, "Vec", "push_each_at", "(Ind Eacher)", 2, this::pushEachAt);
        this.addMethod(vars, "Vec", "pop_front", "", 0, this::popFrontMethod);
        this.addMethod(vars, "Vec", "pop_back", "", 0, this::popBackMethod);
        this.addMethod(vars, "Vec", "pop_at", "(Ind)", 1, this::popAtMethod);
        this.addMethod(vars, "Vec", "concat", "", 0, this::concatMethod);
        this.addMethod(vars, "Vec", "chunk", "(Chunk_size)", 1, this::chunkMethod);
        this.addMethod(vars, "Vec", "just", "", 0, this::justMethod);
        this.addMethod(vars, "Vec", "just_or", "($cont_empty)", 1, this::justOrMethod);
        this.addMethod(vars, "Vec", "with_just_or", "($cont_just, $cont_empty)", 2, this::withJustOrMethod);
        this.addMethod(vars, "Vec", "each", "($proc_elem)", 1, this::eachMethod);
        this.addMethod(vars, "Vec", "map", "($trans)", 1, this::mapMethod);
        this.addMethod(vars, "Vec", "concat_map", "($trans_to_vec)", 1, this::concatMapMethod);
        this.addMethod(vars, "Vec", "filter", "($match?)", 1, this::filterMethod);
        this.addMethod(vars, "Vec", "count", "($match?)", 1, this::countMethod);
        this.addMethod(vars, "Vec", "fold", "(Init $combine)", 2, this::foldMethod);
        this.addMethod(vars, "Vec", "reduce", "($combine)", 1, this::reduceMethod);
        this.addMethod(vars, "Vec", "scan", "(Init $combine)", 2, this::scanMethod);
        this.addMethod(vars, "Vec", "scan_inside", "($combine)", 1, this::scanInsideMethod);
        this.addMethod(vars, "Vec", "take_while", "($match?)", 1, this::takeWhileMethod);
        this.addMethod(vars, "Vec", "drop_while", "($match?)", 1, this::dropWhileMethod);
        this.addMethod(vars, "Vec", "all?", "($match?)", 1, this::allPMethod);
        this.addMethod(vars, "Vec", "any?", "($match?)", 1, this::anyPMethod);
        this.addMethod(vars, "Vec", "have?", "(Target)", 1, this::havePMethod);
        this.addMethod(vars, "Vec", "have_all?", "(For_aller)", 1, this::haveAllPMethod);
        this.addMethod(vars, "Vec", "have_any?", "(For_anyer)", 1, this::haveAnyPMethod);
        this.addMethod(vars, "Vec", "search", "(Min_ind $accept?)", 2, this::searchMethod);
        vars.put(this.vm.sym.handleFor("sort"), this.vm.fun.make("Vec.sort($precede?)").takeMinMax(0, 1).action(this::sortMethod));
        this.addMethod(vars, "Vec", "iter", "", 0, this::iterMethod);
        this.addMethod(vars, "Vec", "iter_from", "(Min_ind)", 1, this::iterFromMethod);
        this.addBinOp(vars, "Vec", "op_add", "Arg_vec", this::opAddMethod);
        this.addMethod(vars, "Vec", "op_store", "(Rhs)", 1, this::opStoreMethod);
        this.addMethod(vars, "Vec", "op_mul", "(Count)", 1, this::opMulMethod);
        this.addBinOp(vars, "Vec", "op_eq", "Arg_vec", this::opEqMethod);
        this.addBinOp(vars, "Vec", "op_lt", "Arg_vec", this::opLtMethod);
        this.addMethod(vars, "Vec", "repr", "", 0, this::reprMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult getMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(c.arg(0), size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        return vecInternal.get(ind);
    }

    private HostResult frontMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise(desc + ": vec is empty");
        }
        return vecInternal.get(0);
    }

    private HostResult backMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise(desc + ": vec is empty");
        }
        return vecInternal.get(size - 1);
    }

    private HostResult setMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(c.arg(0), size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        vec.setVecInternal(vecInternal.set(ind, c.arg(1)));
        return this.vm.nada;
    }

    private HostResult dupMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        return new VecVal(this.vm, vecInternal.copy());
    }

    private HostResult revMethod(CallContext c, VecVal vec, String desc) {
        VecInternal src = vec.vecInternal();
        int size = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, size);
        for (int i = 0; i < size; ++i) {
            dest = dest.append(src.get(size - i - 1));
        }
        return new VecVal(this.vm, dest);
    }

    private void addTakeDropMethod(Map<Integer, Val> vars, String sym, int fromNumCoef, int fromSizeCoef, int toNumCoef, int toSizeCoef) {
        this.addMethod(vars, "Vec", sym, "(N)", 1, (c, vec, desc) -> {
            VecInternal vecInternal = vec.vecInternal();
            int size = vecInternal.size();
            Val numVal = c.arg(0);
            int num = NumOperations.getPosIndex(numVal, size);
            if (num < 0) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(numVal)));
            }
            int from = fromNumCoef * num + fromSizeCoef * size;
            int to = toNumCoef * num + toSizeCoef * size;
            return new VecVal(this.vm, vecInternal.copyRange(from, to));
        });
    }

    private HostResult sliceMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        GraphNode error = this.checkRange(desc, size, c.arg(0), c.arg(1));
        if (error != null) {
            return c.call(error);
        }
        BigDecimal from = ((NumVal)c.arg(0)).bigDecimal();
        BigDecimal to = ((NumVal)c.arg(1)).bigDecimal();
        return new VecVal(this.vm, vecInternal.copyRange(from.intValue(), to.intValue()));
    }

    private HostResult clearMethod(CallContext c, VecVal vec, String desc) {
        vec.setVecInternal(this.empty);
        return this.vm.nada;
    }

    private HostResult clearSliceMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        GraphNode error = this.checkRange(desc, size, c.arg(0), c.arg(1));
        if (error != null) {
            return c.call(error);
        }
        BigDecimal from = ((NumVal)c.arg(0)).bigDecimal();
        BigDecimal to = ((NumVal)c.arg(1)).bigDecimal();
        vec.setVecInternal(vecInternal.removeRange(from.intValue(), to.intValue()));
        return this.vm.nada;
    }

    private HostResult pushFront(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        vec.setVecInternal(vecInternal.insert(0, c.arg(0)));
        return this.vm.nada;
    }

    private HostResult pushBack(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        vec.setVecInternal(vecInternal.append(c.arg(0)));
        return this.vm.nada;
    }

    private HostResult pushAt(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getPosIndex(c.arg(0), size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: required int num in [0, {}] for Ind, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        vecInternal = vecInternal.insert(ind, c.arg(1));
        vec.setVecInternal(vecInternal);
        return this.vm.nada;
    }

    private HostResult pushEachFront(CallContext c, VecVal vec, String desc) {
        Val eacher = c.arg(0);
        if (eacher instanceof VecVal) {
            VecVal eacherVec = (VecVal)eacher;
            VecInternal vecInternal = vec.vecInternal();
            vec.setVecInternal(vecInternal.insertAll(0, eacherVec.vecInternal()));
            return this.vm.nada;
        }
        if (eacher.hasVar(this.eachHandle)) {
            return c.call(eacher, this.eachHandle).args((Val)this.pushEachAtConsume(vec, 0));
        }
        return c.call(this.vm.graph.raiseFormat("{}: Eacher must have .each, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(eacher)));
    }

    private HostResult pushEachBack(CallContext c, VecVal vec, String desc) {
        Val eacher = c.arg(0);
        if (eacher instanceof VecVal) {
            VecVal eacherVec = (VecVal)eacher;
            VecInternal vecInternal = vec.vecInternal();
            int size = vecInternal.size();
            vec.setVecInternal(vecInternal.insertAll(size, eacherVec.vecInternal()));
            return this.vm.nada;
        }
        if (eacher.hasVar(this.eachHandle)) {
            return c.call(eacher, this.eachHandle).args((Val)this.pushEachBackConsume(vec));
        }
        return c.call(this.vm.graph.raiseFormat("{}: Eacher must have .each, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(eacher)));
    }

    private FunVal pushEachBackConsume(VecVal vec) {
        return this.vm.fun.make("Vec.push_each_back-call").take(1).action(c -> {
            VecInternal vecInternal = vec.vecInternal();
            vec.setVecInternal(vecInternal.append(c.arg(0)));
            return this.vm.nada;
        });
    }

    private HostResult pushEachAt(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getPosIndex(c.arg(0), size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        Val adderVal = c.arg(1);
        if (adderVal instanceof VecVal) {
            VecVal adder = (VecVal)adderVal;
            vec.setVecInternal(vecInternal.insertAll(ind, adder.vecInternal()));
            return this.vm.nada;
        }
        if (adderVal.hasVar(this.eachHandle)) {
            return c.call(adderVal, this.eachHandle).args((Val)this.pushEachAtConsume(vec, ind));
        }
        return c.call(this.vm.graph.raiseFormat("{}: Eacher must have .each, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(adderVal)));
    }

    private FunVal pushEachAtConsume(VecVal vec, int initialInd) {
        AtomicInteger indAtomic = new AtomicInteger(initialInd);
        return this.vm.fun.make("Vec.push_each_at-consume").take(1).action(c -> {
            VecInternal vecInternal;
            int size;
            int ind = indAtomic.getAndIncrement();
            if (ind > (size = (vecInternal = vec.vecInternal()).size())) {
                return c.raise("Vec.push_each_at-consume: vec was modified during loop");
            }
            vec.setVecInternal(vecInternal.insert(ind, c.arg(0)));
            return this.vm.nada;
        });
    }

    private HostResult popFrontMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise(desc + ": could not pop from empty vec");
        }
        Val result = vecInternal.get(0);
        vec.setVecInternal(vecInternal.remove(0));
        return result;
    }

    private HostResult popBackMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise(desc + ": could not pop from empty vec");
        }
        Val result = vecInternal.get(size - 1);
        vec.setVecInternal(vecInternal.remove(size - 1));
        return result;
    }

    private HostResult popAtMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(c.arg(0), size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind msut be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        Val result = vecInternal.get(ind);
        vec.setVecInternal(vecInternal.remove(ind));
        return result;
    }

    private HostResult concatMethod(CallContext c, VecVal vecs, String desc) {
        VecInternal src = vecs.vecInternal();
        int srcSize = src.size();
        VecInternal result = this.empty;
        for (int i = 0; i < srcSize; ++i) {
            Val elem = src.get(i);
            if (!(elem instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: Vec must be a vec of vecs, but the #{} elem was {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(elem)));
            }
            VecVal elemVec = (VecVal)elem;
            result = result.insertAll(result.size(), elemVec.vecInternal());
        }
        return new VecVal(this.vm, result);
    }

    private HostResult chunkMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int vecSize = vecInternal.size();
        Val chunkSizeVal = c.arg(0);
        if (!(chunkSizeVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Chunk_size must be an int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(chunkSizeVal)));
        }
        NumVal chunkSizeNum = (NumVal)chunkSizeVal;
        BigDecimal chunkSizeDec = chunkSizeNum.bigDecimal();
        if (vecInternal.size() == 0) {
            boolean sizeIsPositiveInt;
            boolean bl = sizeIsPositiveInt = chunkSizeDec.signum() > 0 && chunkSizeDec.remainder(BigDecimal.ONE).signum() == 0;
            if (!sizeIsPositiveInt) {
                return c.call(this.vm.graph.raiseFormat("{}: Chunk_size must be an int num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(chunkSizeVal)));
            }
            return this.vm.vec.of();
        }
        int chunkSize = NumOperations.getPosIndex(chunkSizeDec, vecSize);
        if (chunkSize < 1 || vecSize % chunkSize != 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Chunk_size must be a positive divisor of {}, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(vecSize)), this.vm.graph.repr(chunkSizeVal)));
        }
        int numChunks = vecSize / chunkSize;
        VecInternal result = VecInternal.ofCapa(this.vm, numChunks);
        for (int i = 0; i < numChunks; ++i) {
            int from = i * chunkSize;
            int to = from + chunkSize;
            VecInternal chunk = vecInternal.copyRange(from, to);
            result = result.append(new VecVal(this.vm, chunk));
        }
        return new VecVal(this.vm, result);
    }

    private HostResult justMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size != 1) {
            String msg = String.format(Locale.ROOT, "%s: Vec must be a 1-elem vec, but the number of elems was %d", desc, size);
            return c.raise(msg);
        }
        return vecInternal.get(0);
    }

    private HostResult justOrMethod(CallContext c, VecVal vec, String desc) {
        Val contEmptyVal = c.arg(0);
        if (!(contEmptyVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $cont_empty must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(contEmptyVal)));
        }
        FunVal contEmpty = (FunVal)contEmptyVal;
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        switch (size) {
            case 0: {
                return c.call(contEmpty);
            }
            case 1: {
                return vecInternal.get(0);
            }
        }
        String msg = String.format(Locale.ROOT, "%s: Vec must be 0-elem or 1-elem vec, but the number of elems was %d", desc, size);
        return c.raise(msg);
    }

    private HostResult withJustOrMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size > 1) {
            return c.call(this.vm.graph.raiseFormat("{}: Vec must be 0-elem or 1-elem vec, but Vec contains {} elements", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size))));
        }
        Val contJustVal = c.arg(0);
        if (!(contJustVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $cont_just must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(contJustVal)));
        }
        FunVal contJust = (FunVal)contJustVal;
        Val contEmptyVal = c.arg(1);
        if (!(contEmptyVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $cont_empty must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(contEmptyVal)));
        }
        FunVal contEmpty = (FunVal)contEmptyVal;
        return size == 0 ? c.call(contEmpty) : c.call(contJust).args(vecInternal.get(0));
    }

    private HostResult eachMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $cont_elem must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal procElem = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        return size == 0 ? this.vm.nada : this.eachLoop(c, vecInternal, 0, size, procElem);
    }

    private HostResult eachLoop(HostContext c, VecInternal vecInternal, int ind, int size, FunVal onElem) {
        Val elem = vecInternal.get(ind);
        int nextInd = ind + 1;
        if (nextInd < size) {
            return c.call(onElem).args(elem).on((cc, ignored) -> this.eachLoop(cc, vecInternal, nextInd, size, onElem));
        }
        return c.call(onElem).args(elem);
    }

    private HostResult mapMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $trans must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal trans = (FunVal)val;
        VecInternal src = vec.vecInternal();
        int size = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, size);
        return this.mapLoop(c, src, dest, 0, trans);
    }

    private HostResult mapLoop(HostContext c, VecInternal src, VecInternal dest, int index, FunVal trans) {
        if (index >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(trans).args(src.get(index)).on((cc, result) -> this.mapLoop(cc, src, dest.append(result), index + 1, trans));
    }

    private HostResult concatMapMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $trans_to_vec must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal trans = (FunVal)val;
        VecInternal src = vec.vecInternal();
        VecInternal dest = this.empty;
        return this.concatMapLoop(c, src, dest, 0, trans, desc);
    }

    private HostResult concatMapLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, FunVal trans, String desc) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(trans).args(src.get(srcIndex)).on((cc, resultVal) -> {
            if (!(resultVal instanceof VecVal)) {
                return cc.call(this.vm.graph.raiseFormat("{}: expected vec for fun result, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(resultVal)));
            }
            VecVal result = (VecVal)resultVal;
            VecInternal newDest = dest.insertAll(dest.size(), result.vecInternal());
            return this.concatMapLoop(cc, src, newDest, srcIndex + 1, trans, desc);
        });
    }

    private HostResult filterMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? msut be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal src = vec.vecInternal();
        VecInternal dest = this.empty;
        return this.filterLoop(c, src, dest, 0, match);
    }

    private HostResult filterLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, FunVal pred) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        Val elem = src.get(srcIndex);
        return c.call(pred).args(elem).on((cc, bool) -> {
            if (!this.vm.bool.isBool(bool)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.filter: expected bool for fun result, but got {}", this.vm.graph.repr(bool)));
            }
            VecInternal newDest = bool == this.vm.bool.trueVal ? dest.append(elem) : dest;
            return this.filterLoop(cc, src, newDest, srcIndex + 1, pred);
        });
    }

    private HostResult countMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        return this.countLoop(c, vecInternal, 0, 0, match, desc);
    }

    private HostResult countLoop(HostContext c, VecInternal vecInternal, int index, int num, FunVal match, String desc) {
        if (index >= vecInternal.size()) {
            return this.vm.num.of(num);
        }
        return c.call(match).args(vecInternal.get(index)).on((cc, bool) -> {
            if (!this.vm.bool.isBool(bool)) {
                return cc.call(this.vm.graph.raiseFormat("{}: expected bool for fun result, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(bool)));
            }
            int newNum = num + (bool == this.vm.bool.trueVal ? 1 : 0);
            return this.countLoop(cc, vecInternal, index + 1, newNum, match, desc);
        });
    }

    private HostResult foldMethod(CallContext c, VecVal vec, String desc) {
        Val combineVal = c.arg(1);
        if (!(combineVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $combine must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(combineVal)));
        }
        FunVal combine = (FunVal)combineVal;
        VecInternal vecInternal = vec.vecInternal();
        return this.foldLoop(c, vecInternal, 0, c.arg(0), combine);
    }

    private HostResult foldLoop(HostContext c, VecInternal vecInternal, int index, Val accum, FunVal combine) {
        int size = vecInternal.size();
        if (index >= size) {
            return accum;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(combine).args(accum, elem).on((cc, newAccum) -> this.foldLoop(cc, vecInternal, nextIndex, newAccum, combine));
        }
        return c.call(combine).args(accum, elem);
    }

    private HostResult reduceMethod(CallContext c, VecVal vec, String desc) {
        Val combineVal = c.arg(0);
        if (!(combineVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $combine must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(combineVal)));
        }
        FunVal combine = (FunVal)combineVal;
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return this.vm.vec.of();
        }
        Val first = vecInternal.get(0);
        return this.reduceLoop(c, vecInternal, 1, first, combine);
    }

    private HostResult reduceLoop(HostContext c, VecInternal vecInternal, int index, Val accum, FunVal combine) {
        if (index >= vecInternal.size()) {
            return this.vm.vec.of(accum);
        }
        return c.call(combine).args(accum, vecInternal.get(index)).on((cc, newAccum) -> this.reduceLoop(cc, vecInternal, index + 1, newAccum, combine));
    }

    private HostResult scanMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(1);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $combine must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        FunVal combine = (FunVal)val;
        VecInternal src = vec.vecInternal();
        int srcSize = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, srcSize + 1);
        dest = dest.insert(0, c.arg(0));
        return this.scanLoop(c, src, dest, 0, c.arg(0), combine);
    }

    private HostResult scanInsideMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $combine must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal combine = (FunVal)val;
        VecInternal src = vec.vecInternal();
        int srcSize = src.size();
        if (srcSize == 0) {
            return this.vm.vec.of();
        }
        VecInternal dest = VecInternal.ofCapa(this.vm, srcSize);
        Val first = src.get(0);
        dest = dest.insert(0, first);
        return this.scanLoop(c, src, dest, 1, first, combine);
    }

    private HostResult scanLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, Val accum, FunVal combine) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(combine).args(accum, src.get(srcIndex)).on((cc, newAccum) -> {
            VecInternal newDest = dest.append(newAccum);
            return this.scanLoop(cc, src, newDest, srcIndex + 1, newAccum, combine);
        });
    }

    private HostResult takeWhileMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        return this.takeWhileLoop(c, vecInternal, 0, match, desc);
    }

    private HostResult takeWhileLoop(HostContext c, VecInternal src, int srcIndex, FunVal match, String desc) {
        int srcSize = src.size();
        if (srcIndex >= srcSize) {
            return new VecVal(this.vm, src.copy());
        }
        Val elem = src.get(srcIndex);
        return c.call(match).args(elem).on((cc, result) -> {
            if (!this.vm.bool.isBool(result)) {
                return cc.call(this.vm.graph.raiseFormat("{}: $match? must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(result)));
            }
            if (result == this.vm.bool.falseVal) {
                return new VecVal(this.vm, src.copyRange(0, srcIndex));
            }
            return this.takeWhileLoop(cc, src, srcIndex + 1, match, desc);
        });
    }

    private HostResult dropWhileMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        return this.dropWhileLoop(c, vecInternal, 0, vecInternal.size(), match, desc);
    }

    private HostResult dropWhileLoop(HostContext c, VecInternal src, int srcIndex, int srcSize, FunVal match, String desc) {
        if (srcIndex >= srcSize) {
            return this.vm.vec.of();
        }
        Val elem = src.get(srcIndex);
        return c.call(match).args(elem).on((cc, result) -> {
            if (!this.vm.bool.isBool(result)) {
                return cc.call(this.vm.graph.raiseFormat("{}: $match? must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(result)));
            }
            if (result == this.vm.bool.falseVal) {
                return new VecVal(this.vm, src.copyRange(srcIndex, srcSize));
            }
            return this.dropWhileLoop(cc, src, srcIndex + 1, srcSize, match, desc);
        });
    }

    private HostResult allPMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        return this.allPLoop(c, vecInternal, 0, match, desc);
    }

    private HostResult allPLoop(HostContext c, VecInternal vecInternal, int index, FunVal match, String desc) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.trueVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(match).args(elem).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("{}: $match? must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.falseVal) {
                    return this.vm.bool.falseVal;
                }
                return this.allPLoop(cc, vecInternal, nextIndex, match, desc);
            });
        }
        return c.call(match).args(elem);
    }

    private HostResult anyPMethod(CallContext c, VecVal vec, String desc) {
        Val val = c.arg(0);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal match = (FunVal)val;
        VecInternal vecInternal = vec.vecInternal();
        return this.forAnyPLoop(c, vecInternal, 0, match, desc);
    }

    private HostResult forAnyPLoop(HostContext c, VecInternal vecInternal, int index, FunVal match, String desc) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.falseVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(match).args(elem).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("{}: $match? must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.trueVal) {
                    return this.vm.bool.trueVal;
                }
                return this.forAnyPLoop(cc, vecInternal, nextIndex, match, desc);
            });
        }
        return c.call(match).args(elem);
    }

    private HostResult havePMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        return this.havePLoop(c, vecInternal, 0, c.arg(0), desc);
    }

    private HostResult havePLoop(HostContext c, VecInternal vecInternal, int index, Val target, String desc) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.falseVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(target, this.opEqHandle).args(elem).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("{}: .op_eq must return bool, but got {} for the #{} elem", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(index)), this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.trueVal) {
                    return this.vm.bool.trueVal;
                }
                return this.havePLoop(cc, vecInternal, nextIndex, target, desc);
            });
        }
        return c.call(target, this.opEqHandle).args(elem);
    }

    private HostResult haveAllPMethod(CallContext c, VecVal vec, String desc) {
        FunVal accept = this.vm.fun.make().take(1).action(cc -> cc.call(vec, this.haveP).args(cc.arg(0)));
        return c.call(c.arg(0), this.allP).args((Val)accept);
    }

    private HostResult haveAnyPMethod(CallContext c, VecVal vec, String desc) {
        FunVal accept = this.vm.fun.make().take(1).action(cc -> cc.call(vec, this.haveP).args(cc.arg(0)));
        return c.call(c.arg(0), this.anyP).args((Val)accept);
    }

    private HostResult searchMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int minInd = NumOperations.getPosIndex(c.arg(0), size);
        if (minInd < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Min_ind must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        Val val = c.arg(1);
        if (!(val instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: $match? must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        FunVal match = (FunVal)val;
        return this.searchMethodLoop(c, vecInternal, minInd, match, size, desc);
    }

    private HostResult searchMethodLoop(HostContext c, VecInternal vecInternal, int ind, FunVal match, int size, String desc) {
        if (ind >= size) {
            return this.vm.vec.of();
        }
        Val elem = vecInternal.get(ind);
        return c.call(match).args(elem).on((cc, r) -> {
            if (!this.vm.bool.isBool(r)) {
                return cc.call(this.vm.graph.raiseFormat("{}: $match? must return a bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(r)));
            }
            if (r.equals(this.vm.bool.trueVal)) {
                return this.vm.vec.of((Val)this.vm.num.of(ind));
            }
            return this.searchMethodLoop(cc, vecInternal, ind + 1, match, size, desc);
        });
    }

    private HostResult sortMethod(CallContext c) {
        Val precedes = c.argCount() == 0 ? this.defaultPrecedesFun : c.arg(0);
        return c.call("kink/_vec/SORT_VEC", this.sortHandle).args(c.recv(), precedes);
    }

    private HostResult iterMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        FunVal ifun = this.forwardIfun(desc + ".ifun", vecInternal, 0, size);
        return c.call("kink/iter/ITER", this.newHandle).args((Val)ifun);
    }

    private HostResult iterFromMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int minInd = NumOperations.getPosIndex(c.arg(0), size);
        if (minInd < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Min_ind must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(c.arg(0))));
        }
        FunVal ifun = this.forwardIfun(desc + ".ifun", vecInternal, minInd, size);
        return c.call("kink/iter/ITER", this.newHandle).args((Val)ifun);
    }

    private FunVal forwardIfun(String prefix, VecInternal vecInternal, int ind, int size) {
        return this.vm.fun.make(prefix).take(2).action(c -> {
            Val proc = c.arg(0);
            if (!(proc instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: $proc must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(proc)));
            }
            Val fin = c.arg(1);
            if (!(fin instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: $fin must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fin)));
            }
            if (ind < size) {
                Val head = vecInternal.get(ind);
                FunVal tail = this.forwardIfun(prefix, vecInternal, ind + 1, size);
                return c.call((FunVal)proc).args(head, (Val)tail);
            }
            return c.call((FunVal)fin);
        });
    }

    private HostResult opAddMethod(CallContext c, VecVal left, VecVal right, String desc) {
        VecInternal result = left.vecInternal().copy();
        int leftSize = result.size();
        result = result.insertAll(leftSize, right.vecInternal());
        return new VecVal(this.vm, result);
    }

    private HostResult opStoreMethod(CallContext c, VecVal lhs, String desc) {
        Val restParam;
        Val arg = c.arg(0);
        if (!(arg instanceof VecVal)) {
            return c.call(ArgsSupport.raiseNotVecRhs(this.vm, arg));
        }
        VecVal rhs = (VecVal)arg;
        VecInternal lhsVi = lhs.vecInternal();
        VecInternal rhsVi = rhs.vecInternal();
        int lhsSize = lhsVi.size();
        int rhsSize = rhsVi.size();
        int mandatoryCount = this.getMandatoryParamsCount(lhsSize, lhsVi);
        int optCount = this.getOptParamsCount(lhsSize, lhsVi, mandatoryCount);
        int restInd = mandatoryCount + optCount;
        Val val = restParam = restInd == lhsSize ? null : lhsVi.get(restInd);
        if (restInd < lhsSize - 1 || restInd == lhsSize - 1 && !restParam.hasVar(this.passRestHandle)) {
            return c.call(this.vm.graph.raiseFormat("{}: unexpected lhs param: {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(restParam)));
        }
        if (rhsSize < mandatoryCount || restParam == null && rhsSize > mandatoryCount + optCount) {
            FunVal fun = ArgsSupport.wrongNumberOfArgs(this.vm, mandatoryCount, this.vm.graph.repr(lhs), rhs);
            return c.call(fun);
        }
        return this.opStoreMandatoryLoop(c, 0, lhsVi, rhsSize, rhsVi, mandatoryCount, optCount, restParam);
    }

    private int getMandatoryParamsCount(int lhsSize, VecInternal lhsVi) {
        for (int i = 0; i < lhsSize; ++i) {
            Val param = lhsVi.get(i);
            if (param instanceof VarrefVal || param.hasVar(this.storeHandle)) continue;
            return i;
        }
        return lhsSize;
    }

    private int getOptParamsCount(int lhsSize, VecInternal lhsVi, int offset) {
        int i = 0;
        while (offset + i < lhsSize) {
            Val param = lhsVi.get(offset + i);
            if (!param.hasVar(this.passArgHandle)) {
                return i;
            }
            ++i;
        }
        return lhsSize - offset;
    }

    private HostResult opStoreMandatoryLoop(HostContext c, int ind, VecInternal lhs, int rhsSize, VecInternal rhs, int mandatoryCount, int optCount, @Nullable Val restParam) {
        while (ind < mandatoryCount) {
            Val param = lhs.get(ind);
            Val rval = rhs.get(ind);
            if (!(param instanceof VarrefVal)) {
                int nextInd = ind + 1;
                return c.call(param, this.storeHandle).args(rval).on((cc, r) -> this.opStoreMandatoryLoop(cc, nextInd, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam));
            }
            VarrefVal varref = (VarrefVal)param;
            Val owner = varref.owner();
            int handle = varref.symHandle();
            owner.setVar(handle, rval);
            ++ind;
        }
        return this.opStoreOptLoop(c, ind, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam);
    }

    private HostResult opStoreOptLoop(HostContext c, int ind, VecInternal lhs, int rhsSize, VecInternal rhs, int mandatoryCount, int optCount, @Nullable Val restParam) {
        if (ind == mandatoryCount + optCount) {
            return this.opStoreRest(c, ind, rhsSize, rhs, restParam);
        }
        Val param = lhs.get(ind);
        HostFunReaction next = (cc, r) -> this.opStoreOptLoop(cc, ind + 1, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam);
        return (ind < rhsSize ? c.call(param, this.passArgHandle).args(rhs.get(ind)) : c.call(param, this.passNothingHandle)).on(next);
    }

    private HostResult opStoreRest(HostContext c, int ind, int rhsSize, VecInternal rhs, @Nullable Val restParam) {
        if (restParam == null) {
            return this.vm.nada;
        }
        VecInternal restArgs = rhs.copyRange(Math.min(ind, rhsSize), rhsSize);
        VecVal restArgsVec = new VecVal(this.vm, restArgs);
        return c.call(restParam, this.passRestHandle).args((Val)restArgsVec);
    }

    private HostResult opMulMethod(CallContext c, VecVal vec, String desc) {
        VecInternal vecInternal = vec.vecInternal();
        BigInteger count = NumOperations.getExactBigInteger(c.arg(0));
        if (count == null || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Count must be an int num in [0, infinity), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        int size = vecInternal.size();
        if (size == 0) {
            return this.vm.vec.of();
        }
        BigInteger resultSizeEstimate = count.multiply(BigInteger.valueOf(size));
        if (resultSizeEstimate.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            return c.call(this.vm.graph.raiseFormat("{}: too long result: size {} * Count {} is {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.of(c.arg(0)), this.vm.graph.of(this.vm.num.of(resultSizeEstimate))));
        }
        int countInt = count.intValueExact();
        VecInternal dest = VecInternal.ofCapa(this.vm, size * countInt);
        for (int i = 0; i < countInt; ++i) {
            dest = dest.insertAll(dest.size(), vecInternal);
        }
        return new VecVal(this.vm, dest);
    }

    private HostResult opEqMethod(CallContext c, VecVal left, VecVal right, String desc) {
        VecInternal lv = left.vecInternal();
        VecInternal rv = right.vecInternal();
        int size = lv.size();
        if (rv.size() != size) {
            return this.vm.bool.falseVal;
        }
        if (size == 0) {
            return this.vm.bool.trueVal;
        }
        return this.eqLoop(c, lv, rv, 0, size, desc);
    }

    private HostResult eqLoop(HostContext c, VecInternal lv, VecInternal rv, int ind, int size, String desc) {
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        if (ind + 1 >= size) {
            return c.call(lelem, this.opEqHandle).args(relem);
        }
        return c.call(lelem, this.opEqHandle).args(relem).on((cc, r) -> {
            if (!this.vm.bool.isBool(r)) {
                return cc.call(this.vm.graph.raiseFormat("{}: .op_eq of an elem must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(r)));
            }
            if (r == this.vm.bool.falseVal) {
                return this.vm.bool.of(false);
            }
            return this.eqLoop(cc, lv, rv, ind + 1, size, desc);
        });
    }

    private HostResult opLtMethod(CallContext c, VecVal left, VecVal right, String desc) {
        VecInternal lv = left.vecInternal();
        VecInternal rv = right.vecInternal();
        int lsize = lv.size();
        int rsize = rv.size();
        return lsize == 0 ? this.vm.bool.of(rsize != 0) : (rsize == 0 ? this.vm.bool.falseVal : (lsize == rsize ? this.compareSameSize(c, lv, rv, 0, lsize) : this.compareDifferentSize(c, lv, rv, 0, Math.min(lsize, rsize), lsize < rsize, desc)));
    }

    private HostResult compareDifferentSize(HostContext c, VecInternal lv, VecInternal rv, int ind, int size, boolean atEnd, String desc) {
        if (ind == size) {
            return this.vm.bool.of(atEnd);
        }
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        return c.call(lelem, this.opLtHandle).args(relem).on((cc, accept) -> {
            if (!this.vm.bool.isBool(accept)) {
                return cc.call(this.vm.graph.raiseFormat("{}: .op_lt of an elem must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(accept)));
            }
            if (accept.equals(this.vm.bool.trueVal)) {
                return this.vm.bool.trueVal;
            }
            return cc.call(relem, this.opLtHandle).args(lelem).on((c3, reject) -> {
                if (!this.vm.bool.isBool(reject)) {
                    return c3.call(this.vm.graph.raiseFormat("{}: .op_lt of an elem must return bool, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(reject)));
                }
                if (reject.equals(this.vm.bool.trueVal)) {
                    return this.vm.bool.falseVal;
                }
                return this.compareDifferentSize(c3, lv, rv, ind + 1, size, atEnd, desc);
            });
        });
    }

    private HostResult compareSameSize(HostContext c, VecInternal lv, VecInternal rv, int ind, int size) {
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        if (ind + 1 == size) {
            return c.call(lelem, this.opLtHandle).args(relem);
        }
        return c.call(lelem, this.opLtHandle).args(relem).on((cc, accept) -> {
            if (!this.vm.bool.isBool(accept)) {
                return cc.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(accept)));
            }
            if (accept.equals(this.vm.bool.trueVal)) {
                return this.vm.bool.trueVal;
            }
            return cc.call(relem, this.opLtHandle).args(lelem).on((c3, reject) -> {
                if (!this.vm.bool.isBool(reject)) {
                    return c3.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(reject)));
                }
                if (reject.equals(this.vm.bool.trueVal)) {
                    return this.vm.bool.falseVal;
                }
                return this.compareSameSize(c3, lv, rv, ind + 1, size);
            });
        });
    }

    private HostResult reprMethod(HostContext c, VecVal vec, String desc) {
        return c.call("kink/_vec/REPR_VEC", this.reprVecHandle).args((Val)vec);
    }

    @Nullable
    private GraphNode checkRange(String prefix, int size, Val fromVal, Val toVal) {
        if (!(fromVal instanceof NumVal)) {
            return this.vm.graph.raiseFormat("{}: From_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fromVal));
        }
        BigDecimal fromDecimal = ((NumVal)fromVal).bigDecimal();
        if (!(toVal instanceof NumVal)) {
            return this.vm.graph.raiseFormat("{}: To_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(toVal));
        }
        BigDecimal toDecimal = ((NumVal)toVal).bigDecimal();
        if (!NumOperations.isRangePair(fromDecimal, toDecimal, size)) {
            return this.vm.graph.raiseFormat("{}: required range pair in [0, {}], but got {} and {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(fromVal), this.vm.graph.repr(toVal));
        }
        return null;
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, int arity, ThrowingFunction3<CallContext, VecVal, String, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, sym, argsDesc);
        int handle = this.vm.sym.handleFor(sym);
        FunVal fun = this.vm.fun.make(desc).take(arity).action(c -> {
            Val patt63421$temp = c.recv();
            if (!(patt63421$temp instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be vec, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(c.recv())));
            }
            VecVal recvVec = (VecVal)patt63421$temp;
            return (HostResult)action.apply(c, recvVec, desc);
        });
        vars.put(handle, fun);
    }

    private void addBinOp(Map<Integer, Val> vars, String recvDesc, String sym, String argDesc, ThrowingFunction4<CallContext, VecVal, VecVal, String, HostResult> action) {
        String argsDesc = "(" + argDesc + ")";
        this.addMethod(vars, recvDesc, sym, argsDesc, 1, (c, recv, desc) -> {
            Val patt64269$temp = c.arg(0);
            if (!(patt64269$temp instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be a vec, but got {}", this.vm.graph.of(this.vm.str.of((String)desc)), this.vm.graph.of(this.vm.str.of(argDesc)), this.vm.graph.repr(c.arg(0))));
            }
            VecVal argVec = (VecVal)patt64269$temp;
            return (HostResult)action.apply((CallContext)c, (VecVal)recv, argVec, (String)desc);
        });
    }

    public VecVal of(List<? extends Val> elems) {
        return elems.isEmpty() ? this.of() : new VecVal(this.vm, VecInternal.of(this.vm, elems));
    }

    public VecVal of(Val[] vals, int from, int to) {
        Preconds.checkRange(from, to, vals.length);
        return from == to ? this.of() : new VecVal(this.vm, VecInternal.of(this.vm, vals, from, to));
    }

    public VecVal of() {
        return new VecVal(this.vm, this.empty);
    }

    public VecVal of(Val e0) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0));
    }

    public VecVal of(Val e0, Val e1) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1));
    }

    public VecVal of(Val e0, Val e1, Val e2) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1, e2));
    }

    public VecVal of(Val e0, Val e1, Val e2, Val e3) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1, e2, e3));
    }

    public VecVal of(Val ... elems) {
        return new VecVal(this.vm, VecInternal.of(this.vm, elems, 0, elems.length));
    }
}

