/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.AllocationSet;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeFastFunGenerator;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.objectweb.asm.Type;

public class MakeValCaptureFastFunGenerator
implements MakeFastFunGenerator {
    private final LvarAccessGenerator lvarAccGen;
    private final Function<FastFunItree, JavaClassIr> compile;
    private final Function<FastFunItree, AllocationSet> analyzeAllocation;
    private final ChildJcirAccumulator jcirAccum;

    public MakeValCaptureFastFunGenerator(LvarAccessGenerator lvarAccGen, Function<FastFunItree, JavaClassIr> compile, Function<FastFunItree, AllocationSet> analyzeAllocation, ChildJcirAccumulator jcirAccum) {
        this.lvarAccGen = lvarAccGen;
        this.compile = compile;
        this.analyzeAllocation = analyzeAllocation;
        this.jcirAccum = jcirAccum;
    }

    @Override
    public List<Insn> makeFun(FastFunItree fun) {
        List<LocalVar> free = this.analyzeAllocation.apply(fun).field();
        int jcirInd = this.jcirAccum.add(() -> this.compile.apply(fun));
        return free.isEmpty() ? MakeFastFunGenerator.generateCombinator(jcirInd) : this.generateNonCombinator(jcirInd, free);
    }

    private List<Insn> generateNonCombinator(int jcirInd, List<LocalVar> free) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
        for (LocalVar lv : free) {
            insns.addAll(this.lvarAccGen.loadLvarAllowNull(lv));
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
        }
        insns.add(InsnsGenerator.invokeMakeFun(free.size(), jcirInd));
        return insns;
    }
}

