/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.AllocationSet;
import org.kink_lang.kink.internal.compile.javaclassir.BindingCaptureFastFunCompiler;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.CompilerSupport;
import org.kink_lang.kink.internal.compile.javaclassir.ControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.FastLvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.InFastFunLetRecGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeValCaptureFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.OverriddenControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ProgramCounterSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.UnchangedControlGenerator;
import org.kink_lang.kink.internal.program.itree.FastFunItree;

public class ValCaptureFastFunCompiler {
    private static final System.Logger LOGGER = System.getLogger(BindingCaptureFastFunCompiler.class.getName());
    private final Vm vm;
    private final String programName;
    private final String programText;

    public ValCaptureFastFunCompiler(Vm vm, String programName, String programText) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
    }

    public JavaClassIr compileControlUnchanged(FastFunItree fun) {
        AllocationSet allocationSet = AllocationSet.valCaptureControlUnchanged(fun);
        KeyStrSupplier keySup = new KeyStrSupplier();
        TraceAccumulator traceAccum = new TraceAccumulator();
        FastLvarAccessGenerator lvarAccGen = new FastLvarAccessGenerator(allocationSet, keySup, traceAccum);
        ChildJcirAccumulator jcirAccum = new ChildJcirAccumulator();
        UnchangedControlGenerator controlGen = new UnchangedControlGenerator(this.vm, this.programName, this.programText, keySup, traceAccum);
        MakeValCaptureFastFunGenerator makeFunGen = new MakeValCaptureFastFunGenerator(lvarAccGen, this::compileControlUnchanged, AllocationSet::valCaptureControlUnchanged, jcirAccum);
        return this.compile(fun, allocationSet, keySup, traceAccum, lvarAccGen, jcirAccum, controlGen, makeFunGen, "unchanged");
    }

    public JavaClassIr compileControlOverridden(FastFunItree fun) {
        AllocationSet allocationSet = AllocationSet.valCaptureControlOverridden(fun);
        KeyStrSupplier keySup = new KeyStrSupplier();
        TraceAccumulator traceAccum = new TraceAccumulator();
        FastLvarAccessGenerator lvarAccGen = new FastLvarAccessGenerator(allocationSet, keySup, traceAccum);
        ChildJcirAccumulator jcirAccum = new ChildJcirAccumulator();
        OverriddenControlGenerator controlGen = new OverriddenControlGenerator(this.vm, this.programName, this.programText, keySup, traceAccum);
        MakeValCaptureFastFunGenerator makeFunGen = new MakeValCaptureFastFunGenerator(lvarAccGen, this::compileControlOverridden, AllocationSet::valCaptureControlOverridden, jcirAccum);
        return this.compile(fun, allocationSet, keySup, traceAccum, lvarAccGen, jcirAccum, controlGen, makeFunGen, "overridden");
    }

    private JavaClassIr compile(FastFunItree fun, AllocationSet allocationSet, KeyStrSupplier keySup, TraceAccumulator traceAccum, LvarAccessGenerator lvarAccGen, ChildJcirAccumulator jcirAccum, ControlGenerator controlGen, MakeFastFunGenerator makeFunGen, String controlDesc) {
        InFastFunLetRecGenerator letRecGen = new InFastFunLetRecGenerator(lvarAccGen, makeFunGen);
        ProgramCounterSupplier pcSup = new ProgramCounterSupplier(traceAccum);
        InsnsGenerator insnsGen = new InsnsGenerator(this.vm, this.programName, this.programText, BindingGenerator.NOT_AVAILABLE, lvarAccGen, makeFunGen, letRecGen, controlGen, keySup, traceAccum, pcSup, jcirAccum);
        List<Insn> insns = this.doResume(fun, allocationSet, insnsGen);
        String desc = String.format(Locale.ROOT, "(val-capture-fast-fun location=(%s) control=%s)", this.vm.location.of(this.programName, this.programText, fun.pos()).desc(), controlDesc);
        LOGGER.log(System.Logger.Level.TRACE, "insns for {0}: {1}", desc, insns);
        return new JavaClassIr(allocationSet.field().size(), insns, traceAccum.traces(), desc, jcirAccum.childJcirFactories());
    }

    private List<Insn> doResume(FastFunItree fun, AllocationSet allocationSet, InsnsGenerator insnsGen) {
        ArrayList<Insn> insns = new ArrayList<Insn>(CompilerSupport.PROLOGUE);
        insns.addAll(CompilerSupport.allocateStack(allocationSet.stack().size()));
        insns.addAll(insnsGen.generate(fun.body(), ResultContext.TAIL));
        insns.addAll(CompilerSupport.EPILOGUE);
        return insns;
    }
}

