/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.contract;

import java.util.Locale;

public final class Preconds {
    Preconds() {
        throw new UnsupportedOperationException("should not be instantiated");
    }

    public static void checkArg(boolean cond, String msg) {
        if (!cond) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkState(boolean cond, String msg) {
        if (!cond) {
            throw new IllegalStateException(msg);
        }
    }

    public static void checkElemIndex(int checkedIndex, int size) {
        if (0 <= checkedIndex && checkedIndex < size) {
            return;
        }
        String msg = String.format(Locale.ROOT, "index must be 0<= and <%d, but actually was %d", size, checkedIndex);
        throw new IndexOutOfBoundsException(msg);
    }

    public static void checkPosIndex(int checkedIndex, int size) {
        if (0 <= checkedIndex && checkedIndex <= size) {
            return;
        }
        String msg = String.format(Locale.ROOT, "index must be 0<= and <=%d, but actually was %d", size, checkedIndex);
        throw new IndexOutOfBoundsException(msg);
    }

    public static void checkRange(int from, int to, int size) {
        if (0 > from) {
            String msg = String.format(Locale.ROOT, "negative from index %d", from);
            throw new IndexOutOfBoundsException(msg);
        }
        if (from > to) {
            String msg = String.format(Locale.ROOT, "from index %d > to index %d", from, to);
            throw new IllegalArgumentException(msg);
        }
        if (to > size) {
            String msg = String.format(Locale.ROOT, "to index %d > size %d", to, size);
            throw new IndexOutOfBoundsException(msg);
        }
    }
}

