/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itree;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kink_lang.kink.internal.program.ast.BindingExpr;
import org.kink_lang.kink.internal.program.ast.DerefExpr;
import org.kink_lang.kink.internal.program.ast.Elem;
import org.kink_lang.kink.internal.program.ast.Expr;
import org.kink_lang.kink.internal.program.ast.ExprVisitor;
import org.kink_lang.kink.internal.program.ast.FunExpr;
import org.kink_lang.kink.internal.program.ast.McallExpr;
import org.kink_lang.kink.internal.program.ast.NumExpr;
import org.kink_lang.kink.internal.program.ast.RcallExpr;
import org.kink_lang.kink.internal.program.ast.SeqExpr;
import org.kink_lang.kink.internal.program.ast.StrExpr;
import org.kink_lang.kink.internal.program.ast.VarrefExpr;
import org.kink_lang.kink.internal.program.ast.VecExpr;
import org.kink_lang.kink.internal.program.itree.ArgVecItree;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.DerefItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.NumItree;
import org.kink_lang.kink.internal.program.itree.RecvItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VecItree;

public class NodeToItreeTranslator
implements Function<Expr, Itree> {
    private final TranslateVisitor visitor = new TranslateVisitor();

    @Override
    public Itree apply(Expr expr) {
        return expr.accept(this.visitor);
    }

    private ItreeElem translateElem(Elem elem) {
        if (elem instanceof Expr) {
            return this.apply((Expr)elem);
        }
        Elem.Spread spread = (Elem.Spread)elem;
        return new ItreeElem.Spread(this.apply(spread.expr()), spread.pos());
    }

    List<ItreeElem> translateElems(List<Elem> elems) {
        return elems.stream().map(this::translateElem).collect(Collectors.toList());
    }

    private class TranslateVisitor
    implements ExprVisitor<Itree> {
        private TranslateVisitor() {
        }

        @Override
        public Itree visitSeq(SeqExpr seq) {
            if (seq.steps().isEmpty()) {
                return new NadaItree(seq.pos());
            }
            List<Itree> steps = seq.steps().stream().map(NodeToItreeTranslator.this::apply).collect(Collectors.toList());
            return new SeqItree(steps, seq.pos());
        }

        @Override
        public Itree visitNum(NumExpr num) {
            return new NumItree(num.num(), num.pos());
        }

        @Override
        public Itree visitStr(StrExpr str) {
            return new StrItree(str.str(), str.pos());
        }

        @Override
        public Itree visitBinding(BindingExpr binding) {
            return new BindingItree(binding.pos());
        }

        @Override
        public Itree visitDeref(DerefExpr deref) {
            return new DerefItree(NodeToItreeTranslator.this.apply(deref.owner()), deref.sym(), deref.pos());
        }

        @Override
        public Itree visitVarref(VarrefExpr varref) {
            return new VarrefItree(NodeToItreeTranslator.this.apply(varref.owner()), varref.sym(), varref.pos());
        }

        @Override
        public Itree visitFun(FunExpr fun) {
            Itree body = NodeToItreeTranslator.this.apply(fun.body());
            int pos = fun.pos();
            LstoreItree recvStore = new LstoreItree(new LocalVar.Original("_Recv"), new RecvItree(pos), pos);
            LstoreItree argsStore = new LstoreItree(new LocalVar.Original("_Args"), new ArgVecItree(pos), pos);
            return new SlowFunItree(new SeqItree(List.of(recvStore, argsStore, body), pos), pos);
        }

        @Override
        public Itree visitVec(VecExpr vec) {
            List<ItreeElem> elems = NodeToItreeTranslator.this.translateElems(vec.elems());
            return new VecItree(elems, vec.pos());
        }

        @Override
        public Itree visitMcall(McallExpr mcall) {
            Itree ownerRecv = NodeToItreeTranslator.this.apply(mcall.ownerRecv());
            List<ItreeElem> args = NodeToItreeTranslator.this.translateElems(mcall.args());
            return new McallItree(ownerRecv, mcall.sym(), args, mcall.pos());
        }

        @Override
        public Itree visitRcall(RcallExpr rcall) {
            Itree owner = NodeToItreeTranslator.this.apply(rcall.owner());
            int pos = rcall.pos();
            String sym = rcall.sym();
            DerefItree fun = new DerefItree(owner, sym, pos);
            Itree recv = NodeToItreeTranslator.this.apply(rcall.recv());
            List<ItreeElem> args = NodeToItreeTranslator.this.translateElems(rcall.args());
            return new SymcallItree(fun, sym, recv, args, pos);
        }
    }
}

