/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.OptRestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.Params;

public class OptRestVecAssignmentOptimizer
extends BaseOptimizer {
    @Override
    public Itree visit(AssignmentItree itree) {
        List<LocalVar> mandatory;
        Itree lhs = itree.lhs();
        if (!(lhs instanceof VecItree)) {
            return itree;
        }
        List<ItreeElem> params = ((VecItree)lhs).elems();
        if (params.isEmpty()) {
            return itree;
        }
        ItreeElem last = params.get(params.size() - 1);
        if (!Params.isRestParam(last)) {
            return itree;
        }
        String restSym = Params.getRestParamSym(last);
        List<ItreeElem> beforeLast = params.subList(0, params.size() - 1);
        List<ItreeElem> expOptParams = beforeLast.subList((mandatory = beforeLast.stream().takeWhile(Params::isMandatoryParam).map(Params::getMandatoryParamSym).map(LocalVar.Original::new).collect(Collectors.toList())).size(), beforeLast.size());
        if (!expOptParams.stream().allMatch(Params::isOptParam)) {
            return itree;
        }
        List<LocalVar> opt = expOptParams.stream().map(Params::getOptParamSym).map(LocalVar.Original::new).collect(Collectors.toList());
        return new OptRestVecAssignmentItree(mandatory, opt, new LocalVar.Original(restSym), itree.rhs(), itree.pos());
    }
}

