package org.kink_lang.kink;

import java.util.Locale;

import org.kink_lang.kink.hostfun.HostResult;

/**
 * HostResultCore to raise an exception made of a Java throwable.
 */
class RaiseThrowableResult extends HostResultCore implements HostResult {

    /** The throwable from which a Kink exception is made. */
    private final Throwable throwable;

    /**
     * Constructs a reaction.
     */
    RaiseThrowableResult(Throwable throwable) {
        this.throwable = throwable;
    }

    /**
     * Returns the throwable from which a Kink exception is made.
     */
    Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    void doTransition(StackMachine stackMachine) {
        stackMachine.transitionToRaiseThrowable(this.throwable);
    }

    @Override
    public HostResultCore makeHostResultCore() {
        return this;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "RaiseThrowableResult(%s)", throwable);
    }

    @Override
    public int hashCode() {
        return this.throwable.hashCode();
    }

    @Override
    public boolean equals(Object arg) {
        return arg == this
            || arg instanceof RaiseThrowableResult
            && this.throwable.equals(((RaiseThrowableResult) arg).throwable);
    }

}

// vim: et sw=4 sts=4 fdm=marker
