package org.kink_lang.kink.hostfun;

import org.kink_lang.kink.Val;

/**
 * Context of a call of a host fun.
 *
 * <p>The context is valid during invocation of the lambda of
 * {@link HostFunBuilder#action(HostFunAction)}.</p>
 *
 * <p>CallContext also supports {@link HostContext} interface,
 * to call a function, raising an exception and so on.</p>
 *
 * <p>See {@link org.kink_lang.kink.hostfun} for usage.</p>
 */
public interface CallContext extends HostContext {

    /**
     * Returns the
     * <a href="../../../../../../manual/language/execution.html#invoke-operation">recv</a>
     * of the current call.
     *
     * @return the recv of the current call.
     */
    Val recv();

    /**
     * Returns the number of args of the current call.
     *
     * <p>The number of the args is the size of the
     * <a href="../../../../../../manual/language/execution.html#invoke-operation">
     * arguments vector</a> of the current call.</p>
     *
     * @return the number of the args.
     */
    int argCount();

    /**
     * Returns the arg of the current call at the index.
     *
     * <p>The result will be the {@code index}th element of
     * the <a href="../../../../../../manual/language/execution.html#invoke-operation">
     * arguments vector</a> of the current call.</p>
     *
     * <p>Precondition: index must be less than the result of {@link #argCount()}.</p>
     *
     * @param index the index of the arg.
     * @return the arg.
     */
    Val arg(int index);

}

// vim: et sw=4 sts=4 fdm=marker
