package org.kink_lang.kink.hostfun;

import org.kink_lang.kink.Val;

/**
 * Call flow step to bind args.
 */
public interface CallFlowToArgs extends CallFlowToOn {

    /**
     * Binds the args to the flow.
     *
     * @param args the args.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val... args);

    /**
     * Binds no args to the flow.
     *
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args();

    /**
     * Binds one arg to the flow.
     *
     * @param arg0 the first arg.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val arg0);

    /**
     * Binds two args to the flow.
     *
     * @param arg0 the first arg.
     * @param arg1 the second arg.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val arg0, Val arg1);

    /**
     * Binds the three args to the flow.
     *
     * @param arg0 the first arg.
     * @param arg1 the second arg.
     * @param arg2 the third arg.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val arg0, Val arg1, Val arg2);

    /**
     * Binds the four args to the flow.
     *
     * @param arg0 the first arg.
     * @param arg1 the second arg.
     * @param arg2 the third arg.
     * @param arg3 the fourth arg.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val arg0, Val arg1, Val arg2, Val arg3);

    /**
     * Binds the five args to the flow.
     *
     * @param arg0 the first arg.
     * @param arg1 the second arg.
     * @param arg2 the third arg.
     * @param arg3 the fourth arg.
     * @param arg4 the fifth arg.
     * @return a call flow with the args.
     */
    public abstract CallFlowToOn args(Val arg0, Val arg1, Val arg2, Val arg3, Val arg4);

}

// vim: et sw=4 sts=4 fdm=marker
