package org.kink_lang.kink.hostfun;

import org.kink_lang.kink.HostResultCore;

/**
 * Result of a host call.
 */
@FunctionalInterface
public interface HostResult {

    /**
     * Returns the core of the result,
     * which the executor handles.
     *
     * <p>This method is intended to be used by the Kink runtime implementation.
     * Do not call this method from your program.</p>
     *
     * @return the core of the result.
     */
    public abstract HostResultCore makeHostResultCore();

}

// vim: et sw=4 sts=4 fdm=marker
