package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.*;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToRecv;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToArgs;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.hostfun.HostContext;

/**
 * Call graph with the form fun[..](...).
 */
class DirectCallGraph implements CallGraphNodeToRecv {

    /** The vm. */
    private final Vm vm;

    /** The fun to call. */
    private final FunVal fun;

    /** The recv of the fun invocation. */
    private final GraphNode recv;

    /** The args of the fun invocation. */
    private final GraphNode[] args;

    /**
     * Makes a call graph in the form fun[recv](...args).
     */
    DirectCallGraph(Vm vm, FunVal fun, GraphNode recv, GraphNode[] args) {
        this.vm = vm;
        this.fun = fun;
        this.recv = recv;
        this.args = args;
    }

    @Override
    public CallGraphNodeToArgs recv(GraphNode recv) {
        return new DirectCallGraph(this.vm, this.fun, recv, this.args);
    }

    @Override
    public GraphNode args(GraphNode... args) {
        return new DirectCallGraph(this.vm, this.fun, this.recv, args);
    }

    @Override
    public HostResult evaluateIn(HostContext c) {
        return c.call(this.recv).on((cc, recvVal) -> {
            return new ArgsCollector(args).collectArgs(cc,
                    (c3, argVals) -> c3.call(fun).recv(recvVal).args(argVals));
        });
    }

}

// vim: et sw=4 sts=4 fdm=marker
