package org.kink_lang.kink.internal.compile.javaclassir;

/**
 * Where the local var is stored?
 */
public sealed interface Allocation {

    /**
     * The local var is the recv of the fun call.
     */
    record Recv() implements Allocation {}

    /**
     * The local var is an arg of the fun call.
     *
     * @param index the index of the arg.
     */
    record Arg(int index) implements Allocation {}

    /**
     * The local var is placed on the data stack.
     *
     * @param index the index on the data stack.
     * @param nonnull whether it is nonnull.
     */
    record Stack(int index, boolean nonnull) implements Allocation {}

    /**
     * The local var is placed on the field of the compiled fun class.
     *
     * @param index the index of the field.
     * @param nonnull whether it is nonnull.
     */
    record Field(int index, boolean nonnull) implements Allocation {}

    /**
     * It is a preloaded fun.
     */
    record Preloaded() implements Allocation {}

    /**
     * It is not used / not stored.
     */
    record Unused() implements Allocation {}

}

// vim: et sw=4 sts=4 fdm=marker
