package org.kink_lang.kink.internal.intrinsicsupport;

import org.kink_lang.kink.*;
import org.kink_lang.kink.hostfun.graph.GraphNode;

/**
 * Support funs for args.
 */
public final class ArgsSupport {

    /**
     * Not instantiated.
     */
    private ArgsSupport() {
    }

    /**
     * Returns wrong-number-of-args fun, which takes no args.
     *
     * @param vm the vm.
     * @param paramCount the expected count of params.
     * @param params the desc of params.
     * @param args the actual args.
     * @return wrong-number-of-args fun.
     */
    public static FunVal wrongNumberOfArgs(
            Vm vm, int paramCount, GraphNode params, VecVal args) {
        int argsCount = args.toList().size();
        String template = argsCount < paramCount
            ? "too few args: for {}, got {}"
            : "too many args: for {}, got {}";
        return vm.fun.make().action(c -> c.call(vm.graph.raiseFormat(
                        template,
                        params,
                        vm.graph.repr(args))));
    }

    /**
     * Returns not-vec-rhs fun, which takes no arg.
     *
     * @param vm the vm.
     * @param rhs the right-hand-side of assignment.
     * @return the fun.
     */
    public static FunVal raiseNotVecRhs(Vm vm, Val rhs) {
        return vm.fun.make().action(c -> c.call(vm.graph.raiseFormat(
                        "Vec.op_store(Rhs): the arg must be a vec, but got {}",
                        vm.graph.repr(rhs))));
    }

}

// vim: et sw=4 sts=4 fdm=marker
