package org.kink_lang.kink.internal.intrinsicsupport;

import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

/**
 * Support funs for if preloaded fun.
 */
public final class IfSupport {

    /**
     * Not instantiated.
     */
    private IfSupport() {
    }

    /**
     * Returns a fun to raise cond-not-bool exception.
     *
     * @param vm the vm.
     * @param actual the actual arg for cond param.
     * @return fun to raise cond-not-bool exception.
     */
    public static FunVal condNotBool(Vm vm, Val actual) {
        String template = "if(Cond $true_cont ...[$false_cont={{}}]):"
            + " Cond must be bool, but got {}";
        var raise = vm.graph.raiseFormat(template, vm.graph.repr(actual));
        return vm.fun.make().action(c -> c.call(raise));
    }

}

// vim: et sw=4 sts=4 fdm=marker
