package org.kink_lang.kink.internal.program.ast;

import java.util.Locale;

/**
 * A compile exception.
 */
class CompileException extends Exception {

    /** Serial version UID of this exception class. */
    private static final long serialVersionUID = -8886736615128372772L;

    /** The start pos of the error location. */
    private final int startPos;

    /** The end pos of the error location. */
    private final int endPos;

    /**
     * Constructs a compile exception.
     */
    CompileException(String message, int startPos, int endPos) {
        super(message, null, false, false);
        this.startPos = startPos;
        this.endPos = endPos;
    }

    /**
     * Returns the start pos of the error location.
     */
    int getStartPos() {
        return this.startPos;
    }

    /**
     * Returns the end pos of the error location.
     */
    int getEndPos() {
        return this.endPos;
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT,
                "%s: %s at %d-%d",
                getClass().getName(), getMessage(), startPos, endPos);
    }

}

// vim: et sw=4 sts=4 fdm=marker
