package org.kink_lang.kink.internal.program.ast;

import java.util.List;

/**
 * A vec expression.
 *
 * @param elems the elems.
 * @param pos   the start pos of the node.
 */
public record VecExpr(List<Elem> elems, int pos) implements Expr {

    /**
     * Constructs a vec expression.
     *
     * @param elems the elems.
     * @param pos   the start pos of the node.
     */
    public VecExpr {
        elems = List.copyOf(elems);
    }

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitVec(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
