package org.kink_lang.kink.internal.program.itree;

import java.math.BigDecimal;

/**
 * An arithmetic operation whose second operand is a number literal.
 *
 * @param recv the first operand of the arithmetic operation.
 * @param op the operator.
 * @param arg the second operand of the arithmetic operation.
 * @param pos the pos index of the itree.
 */
public record BiArithmeticItree(Itree recv, Op op, BigDecimal arg, int pos) implements Itree {

    @Override
    public <T> T accept(ItreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    /**
     * Type of arithmetic operations.
     */
    public enum Op {

        /** {@code op_add} operation. */
        ADD,

        /** {@code op_sub} operation. */
        SUB,

        /** {@code op_mul} operation. */
        MUL

    }

}

// vim: et sw=4 sts=4 fdm=marker
