package org.kink_lang.kink.internal.program.itree;

/**
 * Analyzed content of a local var.
 */
public sealed interface LocalVarContent {

    /**
     * The recv in the fun.
     */
    record Recv() implements LocalVarContent {}

    /**
     * The indexed arg in the fun.
     *
     * @param index the index of the arg.
     */
    record Arg(int index) implements LocalVarContent {}

    /**
     * Another local var.
     *
     * @param lvar the local var, which has the same content with the anlyzed lvar.
     */
    record Alias(LocalVar.Generated lvar) implements LocalVarContent {}

    /**
     * Unknown content.
     */
    record Unknown() implements LocalVarContent {}

}

// vim: et sw=4 sts=4 fdm=marker
